<?php
if (! current_user_can ('manage_options')){
    wp_die (__ ('No tienes suficientes permisos para acceder a esta página.'));
}
if (! in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
    wp_die (__ ('No has instalado wooCommerce o este se encuentra inactivo.'));
}

require_once dirname( __FILE__ ) . '/' . '../includes/api_etiqueta.php';
require_once dirname( __FILE__ ) . '/' . '../includes/srv_manifiesto.php';
require_once dirname( __FILE__ ) . '/' . '../includes/tbl_envios.php';
?>

<div class="wrap">
    <h1 class="wp-heading-inline">Correos de Chile - Administrador de Envíos</h1>
    <hr class="wp-header-end">
    <br>
    <?php
        $estado = '';
        $fechaDesde = date('d-m-Y');
        $fechaHasta = date('d-m-Y'); 
        $order_id = '';
        $conEtiqueta = ''; 
        $conRetiro = '';
        $accion_masiva   = '';
        
        if ($_SERVER['REQUEST_METHOD'] === 'POST') 
        {
            $estado = filter_input(INPUT_POST, 'estado');
            $fechaDesde = filter_input(INPUT_POST, 'fechaDesde');
            $fechaHasta = filter_input(INPUT_POST, 'fechaHasta'); 
            $order_id = filter_input(INPUT_POST, 'order_id');
            $conEtiqueta = filter_input(INPUT_POST, 'conEtiqueta'); 
            $conRetiro = filter_input(INPUT_POST, 'conRetiro');
            $accion_masiva  = filter_input(INPUT_POST, 'accion_masiva');
                
            if(is_null($order_id) || is_bool($order_id) || !is_numeric($order_id)){ $order_id = ''; }
            if(is_null($conEtiqueta) || is_bool($conEtiqueta)){ $conEtiqueta = ''; } else { $conEtiqueta = 'S'; }
            if(is_null($conRetiro) || is_bool($conRetiro)){ $conRetiro = ''; } else { $conRetiro = 'S'; }
        }

        $envios = correoschile_buscarEnvios($fechaDesde, $fechaHasta, $order_id, $conEtiqueta, $conRetiro);
        
        $diff1Day = new DateInterval('P1D');
        $fecha = new DateTime();
        $fecha = $fecha->add($diff1Day);
        $fechaRetiro = $fecha->format('d-m-Y');
    ?>
    
    <div class="cch_msg" style="display: none;">
        <h2 class="title"></h2>
        <p class="nota"></p>
        <p class="msg"></p>
        <button id="btnCancelar" type="button" class="button button-primary">Cancelar</button>
    </div>
    
    <form method="POST">
    <ul class="subsubsub">
    </ul>
    
    <div class="tablenav top">
        <div class="alignleft actions bulkactions">
            <label for="bulk-action-selector-top" class="screen-reader-text">Seleccionar acción múltiple</label>
            <select id="accion_masiva" id="bulk-action-selector-top" name="accion_masiva">
                <option value="">Acciones masivas</option>
                <option value="generar_etiquetas">Generar Etiquetas</option>
                <option value="solicitar_retiro">Solicitar Retiro</option>
                <option value="generar_manifiesto">Generar Manifiesto</option>
            </select>
            <input type="button" id="aplicar" class="button action" value="Aplicar">
        </div>
        <div class="alignleft actions">
            <select id="estado" name="estado">
                <option value="">Todos los estados</option>
                <?php 
                    $statuses = wc_get_order_statuses();
                    foreach($statuses as $key => $value) 
                    {
                        $statusReplaced = str_replace('wc-', '', $key);
                        ?><option value="<?php echo $statusReplaced ?>" <?php echo ($estado === $statusReplaced ? "selected" : "") ?>><?php echo $value ?></option><?php
                    }
                ?>
            </select>
            <strong><label for="fechaDesde">Desde:</label></strong>
            <input type="text" autocomplete="off" class="cch_datepicker dtp" id="fechaDesde" name="fechaDesde" value="<?php echo $fechaDesde ?>" maxlength="10" placeholder="dd-mm-yyyy">
            &nbsp;&nbsp;
            <strong><label for="fechaHasta">Hasta:</label></strong>
            <input type="text" autocomplete="off" class="cch_datepicker dtp" id="fechaHasta" name="fechaHasta" value="<?php echo $fechaHasta ?>" maxlength="10" placeholder="dd-mm-yyyy">
            &nbsp;&nbsp;
            <strong><label for="conEtiqueta">Con etiqueta:</label></strong>
            <input type="checkbox" id="conEtiqueta" name="conEtiqueta" <?php echo $conEtiqueta === 'S' ? 'checked="checked"': '' ?>/>
            &nbsp;&nbsp;
            <strong><label for="conRetiro">Con Retiro:</label></strong>
            <input type="checkbox" id="conRetiro" name="conRetiro" <?php echo $conRetiro === 'S' ? 'checked="checked"': '' ?> />
            &nbsp;&nbsp;
            <button id="btnBuscar" type="submit" class="button">Filtrar</button>
        </div>
    </div>
    </form>

    <table id="envios" class="wp-list-table widefat fixed striped posts">
	<thead>
            <tr>
		<td id="cb" class="manage-column column-cb check-column">
                    <label class="screen-reader-text" for="cb-select-all-1">Seleccionar todo</label><input id="cb-select-all-1" type="checkbox">
                </td>
                <th scope="col"><span>Pedido</span></th>
                <th scope="col"><span>Fecha</span></th>
                <th scope="col"><span>Estado</span></th>
                <th scope="col"><span>Etiqueta</span></th>
                <th scope="col"><span>Retiro</span></th>
                <th scope="col"><span>Error</span></th>
            </tr>
	</thead>
	<tbody id="the-list">
        <?php
            foreach($envios as $envio)
            {
                $order = wc_get_order($envio->order_id);
                if(!is_bool($order))
                {
                    $extension = 'pdf';
                    if($envio->formatoEtiqueta === 'ZPL'){
                        $extension = 'txt';
                    }
                    $order_data = $order->get_data();
                    if($estado !== '')
                    {
                        $orderStatus = $order_data['status'];
                        if($estado !== $orderStatus)
                        {
                            continue;
                        }
                    }                    
                    $tr = '';
                    $tr.= '<tr>'; 
                    $tr.= '<th scope="row" class="check-column"><label class="screen-reader-text" for="cb-select-' . $order_data['id'] . '"></label><input data-id="' . $order_data['id'] . '" id="cb-select-' . $order_data['id'] . '" type="checkbox"></th>';
                    $tr.= '<td class="order_number column-order_number has-row-actions column-primary" data-colname="Pedido"><a href="#" data-id="' . $order_data['id'] . '" class="order-view"><strong>' . $order_data['id'] . ' ' . $order_data['billing']['first_name'] . ' ' . $order_data['billing']['last_name'] . '</strong></a></td>';
                    $tr.= '<td>' . substr($envio->fechaCreacion, 0, 16) . '</td>';
                    $tr.= '<td>' . wc_get_order_status_name($order_data['status']) . '</td>';
                    
                    $uploadDir   = wp_upload_dir();
                    $baseUrl = $uploadDir['baseurl'];
                    $baseUrl .= '/correoschile_etiquetas/';
                    
                    $tr.= '<td>' . (is_null($envio->numeroEnvio) ? '-' : ('<a href="' . $baseUrl . $envio->numeroEnvio . '.' . $extension) . '" target="blank"><strong>' . $envio->numeroEnvio . '</strong></a>'). '</td>';
                    $tr.= '<td>' . (is_null($envio->codigoRetiro) ? '-' : ($envio->fechaRetiro . ' ' . $envio->horaRetiroDesde) . '-' . $envio->horaRetiroHasta) . '</td>';
                    $tr.= '<td>' . $envio->error . '</td>';
                    $tr.= '</tr>';
                    echo $tr;
                }
            }
        ?>    
        </tbody>
	<tfoot>
    </table>            
</div>

<div id="dlg_generador_etiquetas" title="Confirmar generación de etiquetas" style="display:none;">
    <div class="contenido1">
        <p><strong>¿Desea crear etiquetas para los envíos seleccionados?</strong></p>
        <p><i>NOTA: Sólo los envíos con estado "Procesando" y no tengan etiqueta serán considerados</i></p>
        <hr>
        <div class="cch-right">
            <button id="btnSiGeneracionEtiquetas" type="button" class="cch_w50 button button-primary">Sí</button>
            <button id="btnNoGeneracionEtiquetas" type="button" class="cch_w50 button">No</button>
        </div>
    </div>
    <div class="contenido2">
        <p><strong>Generando etiquetas...</strong></p>
        <i><span class="cch_loading">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Por favor espere que el proceso termine para continuar navegando por el sitio, de lo contrario será detenido.</span></i>
        <hr>
        <div class="cch-right">
            <button id="btnCancelarGeneracionEtiquetas" type="button button-primary" class="button button-primary">Cancelar</button>
        </div>
    </div>
</div>

<div id="dlg_generador_manifiesto" title="Confirmar generación de manifiesto" style="display:none;">
    <div class="contenido1">
        <p><strong>¿Desea generar el manifiesto para los envíos seleccionados?</strong></p>
        <p><i>NOTA: Sólo los pedidos en estado <strong>Procesando</strong>, con etiqueta y fecha de retiro serán considerados.</i></p>
        <hr>
        <div class="cch-right">
            <button id="btnSiGeneracionManifiesto" type="button" class="cch_w50 button button-primary">Sí</button>
            <button id="btnNoGeneracionManifiesto" type="button" class="cch_w50 button">No</button>
        </div>
    </div>
    <div class="contenido2">
        <p><strong>Generando manifiesto...</strong></p>
        <i class="mensaje"><span class="cch_loading">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Por favor espere que el proceso termine para continuar navegando por el sitio.</span></i>
        <hr>
        <div class="cch-right">
            <a href="#" target="blank" id="btnDescargarManifiesto" type="button button-primary" class="button button-primary" style="display:none;">Descargar</a>
            <button id="btnCerrarGeneracionManifiesto" type="button" class="button button-primary">Cerrar</button>
        </div>
    </div>
</div>

<div id="dlg_solicitar_retiro" title="Confirmar solicitud de retiro" style="display:none;">
    <div class="contenido1">
        <p><strong>¿Desea solicitar el retiro para los envíos seleccionados?</strong></p>
        <p><i>NOTA: Sólo los pedidos en estado <strong>Procesando</strong>, con etiqueta y sin fecha de retiro serán considerados.</i></p>
        <hr>
        <div class="cch-right">
            <button id="btnSiSolicitarRetiro" type="button" class="cch_w50 button button-primary">Sí</button>
            <button id="btnNoSolicitarRetiro" type="button" class="cch_w50 button">No</button>
        </div>
    </div>
    <div class="contenido2">
        <div>
            <table>
                <tr>
                    <td valign="top">
                        <strong>Fecha</strong>
                    </td>
                    <td valign="top">
                        <input type="text" autocomplete="off" class="cch_datepicker dtpr" id="fechaRetiro" name="fechaRetiro" value="<?php echo $fechaRetiro ?>" maxlength="10" placeholder="dd-mm-yyyy">
                        <br>
                        <span style="color:red;" id="lblfechaRetiro"></span>
                        <br>
                        <br>
                    </td>
                </tr>
                <tr>
                    <td valign="top">
                        <strong>Horario&nbsp;&nbsp;&nbsp;&nbsp;</strong>
                    </td>
                    <td valign="top">
                        <input id="mañana" class="horario" type="radio" name="horario" checked value="mañana"><label for="mañana">Mañana (09:00 hrs - 13:00 hrs)</label>
                        <br>
                        <input id="tarde" class="horario" type="radio" name="horario" value="tarde"><label for="tarde">Tarde (15:00 hrs - 17:30 hrs)</label>
                    </td>
                </tr>
                <tr>
                    <td colspan="2" valign="top">
                        <br/>
                        <input type="checkbox" id="reAgendar" name="reAgendar"/>
                        <label for="reAgendar">Reagendar</label>  
                    </td>
                </tr>
            </table>
        </div>
        <hr>
        <div class="cch-right">
            <button id="btnContinuarSolicitarRetiro" type="button" class="button button-primary">Continuar</button>
            <button id="btnAbotarSolicitarRetiro" type="button" class="button">Cancelar</button>
        </div>
    </div>    
    <div class="contenido3">
        <p><strong>Solicitando Retiros...</strong></p>
        <i><span class="cch_loading">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Por favor espere que el proceso termine para continuar navegando por el sitio, de lo contrario será detenido.</span></i>
        <hr>
        <div class="cch-right">
            <button id="btnCancelarSolicitarRetiro2" type="button" class="button button-primary">Cancelar</button>
        </div>
    </div>
</div>

<div id="dlg_editor" title="Pedido N°" style="display:none;">
    <div class="contenido1">
        <table>
            <tr>
                
            </tr>
        </table>
    </div>
</div>

<div id="dlg_mensaje" title="">
    <p></p>
</div>

<?php
    $path = plugin_dir_url(__FILE__);
    wp_enqueue_style('correoschile_jquery', $path . 'css/jquery-ui.min.css');
    wp_enqueue_style('correoschile_envios', $path . 'css/correoschile_admin_envios.css');
    wp_enqueue_script('correoschile_envios', $path . 'js/correoschile_admin_envios.js', ['jquery', 'jquery-ui-core', 'jquery-ui-dialog', 'jquery-ui-datepicker'], '', true );
    wp_localize_script('correoschile_envios', 'correoschile_var', 
        array('url' => admin_url('admin-ajax.php'), 
            'nonce_etiqueta' => wp_create_nonce('nonce_etiqueta'),
            'nonce_manifiesto' => wp_create_nonce('nonce_manifiesto'),
            'nonce_retiro' => wp_create_nonce('nonce_retiro')));
    
    $fecha = date('Ymd');
    $strFecha = date('d-m-Y');
    $h = date_format(new DateTime('NOW'), 'H');
    $agendarHoy = $h < 14 ? true : false;
    if($agendarHoy === false){
        $fecha = date_format(new DateTime('+1 day'), 'Ymd');
        $strFecha = date_format(new DateTime('+1 day'), 'd-m-Y');
    }
?>
<script>
    jQuery(document).ready(function(){
        new correoschile_envios({ fecha: <?php echo $fecha; ?>, strFecha: '<?php echo $strFecha; ?>' });
    });
</script>
