<?php
include_once ('api_normalizacion.php');
include_once ('tbl_envios.php');

function correoschile_ajax_generar_etiqueta() 
{
    if ($_SERVER['REQUEST_METHOD'] === 'POST') 
    {
        $tieneEnvio = false;
        try 
        {
            $order_id = filter_input(INPUT_POST, 'order_id');
            if(!isset($order_id))
            {
                throw new Exception('No se proporciono la variable "order_id"');
            }
            $order = wc_get_order(intval($order_id));
            if(is_bool($order))
            {
                throw new Exception('No se encontró la información del pedido ' . $order_id);
            }
            $envio = correoschile_obtenerEnvio($order_id);
            if(is_null($envio))
            {
                throw new Exception('No se encontró la información del envío ' . $order_id);
            }
            $tieneEnvio = true;
            $estado = $order->get_status();
            if($estado !== 'processing')
            {
                throw new Exception('Solo pueden generarse etiquetas para pedidos en proceso');
            }
            if(!is_null($envio->numeroReferencia))
            {
                header('http/1.1 500 Internal Server Error');
                header('Content-Type: application/json; charset=UTF8');
                die(json_encode(array('message' => 'Ya existe una etiqueta para este envío.')));
            }
            
            $nombreDestinatario = $order->get_shipping_first_name() . ' ' . $order->get_shipping_last_name();
            $direccionDestinatario = $order->get_shipping_address_1();
            $comunaDestinatario = $order->get_shipping_city();
            $telefonoDestinatario = $order->get_billing_phone();
            $codigoServicio = $envio->codigoServicio;
            $numeroTotalPiezas = $envio->numeroTotalPiezas;
            $kilos = $envio->kilos;
            $volumen = $envio->volumen;
            $numeroReferencia = substr($order->get_order_key(),9);
            $observaciones = $order->get_customer_note();
            $observaciones2 = '';
            $emailDestinatario = $order->get_billing_email();
            $formatoEtiqueta = get_option('correoschile_formato_etiqueta','PDF');
                    
            correoschile_validar_generacion_etiqueta(
                $order_id, $nombreDestinatario, $direccionDestinatario, $comunaDestinatario, $telefonoDestinatario, $codigoServicio,
                $numeroTotalPiezas, $kilos, $volumen, $numeroReferencia, $observaciones, $observaciones2, $emailDestinatario, $formatoEtiqueta);
            
            $numeroEnvio = correoschile_generar_etiqueta(
                $order_id, $nombreDestinatario, $direccionDestinatario, $comunaDestinatario, $telefonoDestinatario, $codigoServicio,
                $numeroTotalPiezas, $kilos, $volumen, $numeroReferencia, $observaciones, $observaciones2, $emailDestinatario, $formatoEtiqueta);
            
            correoschile_actualizarEnvio_InfoAdmision($order_id, $order_id, $numeroReferencia, $numeroEnvio, $formatoEtiqueta);

            $uploadDir   = wp_upload_dir();
            $baseUrl = $uploadDir['baseurl'];
            $baseUrl .= '/correoschile_etiquetas/';
            $extension = 'pdf';
            if($formatoEtiqueta === 'ZPL')
            {
                $extension = 'txt';
            }
            
            $html = '<a href="' . $baseUrl . $numeroEnvio . '.' . $extension . '" target="blank"><strong>' . $numeroEnvio . '</strong></a>';
            header('http/1.1 200 OK');
            header('Content-Type: application/json; charset=UTF8');
            echo json_encode(array('html' => $html));
            exit();
        }
        catch (Exception $e) 
        {
            if($tieneEnvio === true)
            {
                correoschile_actualizarEnvio_InfoError($order_id, $e->getMessage());
            }
            header('http/1.1 500 Internal Server Error');
            header('Content-Type: application/json; charset=UTF8');
            die(json_encode(array('message' => $e->getMessage())));
        }
    } 
    else 
    {
        header('http/1.1 500 Internal Server Error');
        header('Content-Type: application/json; charset=UTF8');
        die(json_encode(array('message' => 'Este método solo puede ser invocado con POST')));
    }
}

function correoschile_validar_generacion_etiqueta($codigoAdmision, $nombreDestinatario, $direccionDestinatario, $comunaDestinatario, 
                                                  $telefonoDestinatario, $codigoServicio, $numeroTotalPiezas, $kilos, $volumen,
                                                  $numeroReferencia, $observaciones, $observaciones2, $emailDestinatario, $formatoEtiqueta) 
{
    $mensaje = '';
    try 
    {
        $remitenteNormalizado = correoschile_normalizacion(get_option('correoschile_direccion',''), get_option('correoschile_comuna',''));
    }
    catch (Exception $ex) 
    {
        $mensaje.= ($mensaje !== '' ? '<br>':'') . 'La dirección de remitente no se encuentra normalizada.';
    }
    try
    {
        $destinatarioNormalizado = correoschile_normalizacion($direccionDestinatario, $comunaDestinatario);
    }
    catch (Exception $ex) 
    {
        $mensaje.= ($mensaje !== '' ? '<br>':'') . 'La dirección del destinatario no se encuentra normalizada.';
    }    
    if($mensaje !== '')
    {
        throw new Exception($mensaje);
    }
    
}

function correoschile_generar_etiqueta($codigoAdmision, $nombreDestinatario, $direccionDestinatario, $comunaDestinatario, 
                                       $telefonoDestinatario, $codigoServicio, $numeroTotalPiezas, $kilos, $volumen,
                                       $numeroReferencia, $observaciones, $observaciones2, $emailDestinatario, $formatoEtiqueta)
{
    $data = array(
        'Usuario' => get_option('correoschile_usuario_api',''), //string
        'Contrasena' => get_option('correoschile_contrasena_api',''), //string
        'admisionTO' => array(
            'CodigoAdmision' => $codigoAdmision, //string
            'ClienteRemitente' => get_option('correoschile_codigoSAP',''), //string
            'CentroRemitente' => '', //string
            'NombreRemitente' => get_option('correoschile_nombre_tienda',''), //string
            'DireccionRemitente' => get_option('correoschile_direccion',''), //string
            'PaisRemitente' => '056', //string
            'CodigoPostalRemitente' => get_option('correoschile_codigoPostal',''), //string
            'ComunaRemitente' => get_option('correoschile_comuna',''), //string
            'RutRemitente' => get_option('correoschile_rut',''), //string
            'PersonaContactoRemitente' => get_option('correoschile_nombre',''), //string
            'TelefonoContactoRemitente' => correoschile_soloNumeros(get_option('correoschile_telefono','')), //string
            'ClienteDestinatario' => '', //string
            'CentroDestinatario' => '', //string
            'NombreDestinatario' => $nombreDestinatario, //string
            'DireccionDestinatario' => $direccionDestinatario, //string
            'PaisDestinatario' => '056', //string
            'CodigoPostalDestinatario' => '', //string
            'ComunaDestinatario' => $comunaDestinatario, //string
            'RutDestinatario' => '', //string
            'PersonaContactoDestinatario' => $nombreDestinatario, //string
            'TelefonoContactoDestinatario' => correoschile_soloNumeros($telefonoDestinatario), //string
            'CodigoServicio' => $codigoServicio, //string
            'NumeroTotalPiezas' => $numeroTotalPiezas, //int
            'Kilos' => $kilos, //double
            'Volumen' => $volumen, //double
            'NumeroReferencia' => $numeroReferencia, //string
            'ImporteReembolso' => 0, //long
            'ImporteValorDeclarado' => 0, //long
            'TipoPortes' => 'P', //string
            'Observaciones' => $observaciones, //string
            'Observaciones2' => $observaciones2, //string
            'EmailDestino' => $emailDestinatario, //string
            'TipoMercancia' => '', //string
            'DevolucionConforme' => 'N', //string
            'NumeroDocumentos' => 0, //long
            'PagoSeguro' => 'N', //string
            'FormatoEtiqueta' => $formatoEtiqueta //string
        )
    );
   
    try 
    {
        $jsonData = json_encode($data);
        require 'guzzle/vendor/autoload.php';
        $request = new \GuzzleHttp\Client([ 'headers' => [ 'Content-Type' => 'application/json' ]]);
        $url = get_option('correoschile_ws_etiquetas', '');
        $response = $request->post($url, ['body' => $jsonData]);
        $header = $response->getHeader('Content-Disposition');
        $body = $response->getBody()->getContents();
        $header_array = explode('=', $header[0]);
        $file_name = $header_array[1];
        $numeroEnvio = explode('.', $file_name)[0];
        
        $upload_dir   = wp_upload_dir();
        $upload_dirname = $upload_dir['basedir'];
        $upload_dirname .= '/correoschile_etiquetas';
        if(!file_exists($upload_dirname))
        {
            wp_mkdir_p($upload_dirname);
        }
        $fullFileName = $upload_dirname . '/' . $file_name;
        $total_bytes = file_put_contents($fullFileName, $body);
        $full_file_name = $fullFileName;
        return $numeroEnvio;
    }
    catch (GuzzleHttp\Exception\RequestException $e)
    {
        $contenido = $e->getResponse()->getBody();
        $contenidoJson = json_decode($contenido);
        throw new Exception($contenidoJson->Message);
    }
    catch(Exception $e)
    {
        throw new Exception('Ocurrio un error intentando generar la etiqueta ' . $order_id);
    }
}

function correoschile_soloNumeros($texto)
{
    return $texto;
}
