<?php

function correoschile_ajax_normalizacion() 
{
    if ($_SERVER['REQUEST_METHOD'] === 'POST') 
    {
        try 
        {
            $direccion = filter_input(INPUT_POST, 'direccion');
            $comuna = filter_input(INPUT_POST, 'comuna');
            $direccion = correoschile_normalizacion($direccion, $comuna);
            header('http/1.1 200 OK');
            header('Content-Type: application/json; charset=UTF8');
            echo json_encode($direccion);
            exit();
        } 
        catch(Exception $e)
        {
            header('http/1.1 500 Internal Server Error');
            header('Content-Type: application/json; charset=UTF8');
            die(json_encode(array('message' => $e->getMessage())));
        }
    } 
    else 
    {
        header('http/1.1 500 Internal Server Error');
        header('Content-Type: application/json; charset=UTF8');
        die(json_encode(array('message' => 'Este método solo puede ser invocado con POST')));
    }      
}

function correoschile_normalizacion($direccion, $comuna)
{
    $wsdl = trim(get_option('correoschile_ws_normalizacion', ''));
    if($wsdl !== '' && substr_compare(strtolower($wsdl), '?wsdl', -strlen('?wsdl')) < 0){
        $wsdl .= '?wsdl';
    }
    try
    {
        $client = new SoapClient($wsdl, array('trace' => 1, 'exception' => 0));
        $result = $client->__soapCall('normalizarDireccion', array(
            'normalizarDireccion' => array(
                'usuario' => trim(get_option('correoschile_usuario_api')),
                'contrasena' => trim(get_option('correoschile_contrasena_api')),
                'id' => '0',
                'direccion' => trim($direccion),
                'comuna' => trim($comuna)
            )), null, null);
        return $result->normalizarDireccionResult;
    }
    catch (SoapFault $e) {
        throw new Exception($e->getMessage(), 0, $e);
    }
    catch (Exception $e) {
        throw new Exception('Ocurio un errror intentando obtener las comunas.', 0, $e);
    }
}