<?php

function correoschile_ajax_registrar_retiro() 
{
    if ($_SERVER['REQUEST_METHOD'] === 'POST') 
    {
        $tieneEnvio = false;
        try 
        {
            $order_id = filter_input(INPUT_POST, 'order_id');
            $fechaRetiro = filter_input(INPUT_POST, 'fecha');
            $horaDesde = filter_input(INPUT_POST, 'horaDesde');
            $horaHasta = filter_input(INPUT_POST, 'horaHasta');
            $reAgendar = filter_input(INPUT_POST, 'reAgendar');

            if(!isset($order_id)) throw new Exception('No se proporciono la variable "order_id"');
            if(!isset($fechaRetiro)) throw new Exception('No se proporciono la variable "fecha"');
            if(!isset($horaDesde)) throw new Exception('No se proporciono la variable "horaDesde"');
            if(!isset($horaHasta)) throw new Exception('No se proporciono la variable "horaHasta"');
            if(!isset($reAgendar)) throw new Exception('No se proporciono la variable "reAgendar"');

            $order = wc_get_order(intval($order_id));
            if(is_bool($order))
                throw new Exception('No se encontró la información del pedido ' . $order_id);
            $estado = $order->get_status();
            if($estado !== 'processing')
                throw new Exception('Solo pueden generarse retiros para pedidos en proceso');
            $envio = correoschile_obtenerEnvio($order_id);
            if(is_null($envio)) 
                throw new Exception('No se encontró la información del envío ' . $order_id);
            $tieneEnvio = true;
            $codigoAdmision = $envio->codigoAdmision;
            $codigoRetiro = $envio->codigoRetiro;
            if(is_null($codigoAdmision))
                throw new Exception('El pedido aún no cuenta con etiqueta ');
            if($reAgendar !== 'S') {
                if(isset($codigoRetiro)) {
                    throw new Exception('El pedido ya cuenta son una solicitud de retiro ');
                }
            }
            //INCORPORAR VALIDACION
            //1) - los retiros se pueden agendar entre 09:00 y 17:00
            //2) - de 09:00 a 13:00 se puede agendar para la tarde.
            //3) - de 13:00 a 17:00 
            
            $fecha = explode('-', $fechaRetiro);
            $fecha = $fecha[2] . '-' . $fecha[1] . '-' . $fecha[0];
            
            $result = correoschile_registrar_retiro($codigoAdmision, $fecha, $horaDesde, $horaHasta);
            correoschile_actualizarEnvio_InfoRetiro($order_id, strval($result->CodigoRetiro), $fechaRetiro, $horaDesde, $horaHasta);
            $retiro = $fechaRetiro . ' ' . $horaDesde . '-' . $horaHasta;
            header('http/1.1 200 OK');
            header('Content-Type: application/json; charset=UTF8');
            echo json_encode(array('retiro' => $retiro));
            exit();
        }
        catch(Exception $e)
        {
            if($tieneEnvio){
                correoschile_actualizarEnvio_InfoError($order_id, $e->getMessage());
            }
            header('http/1.1 500 Internal Server Error');
            header('Content-Type: application/json; charset=UTF8');
            die(json_encode(array('message' => $e->getMessage())));
        }
    } 
    else 
    {
        header('http/1.1 500 Internal Server Error');
        header('Content-Type: application/json; charset=UTF8');
        die(json_encode(array('message' => 'Este método solo puede ser invocado con POST')));
    }
}

function correoschile_registrar_retiro($codigoAdmision, $fecha, $horaDesde, $horaHasta)
{
    $wsdl = trim(get_option('correoschile_ws_retiro', ''));
    if($wsdl !== '' && substr_compare(strtolower($wsdl), '?wsdl', -strlen('?wsdl')) < 0){
        $wsdl .= '?wsdl';
    }
    try
    {
        $client = new SoapClient($wsdl, array('trace' => 1, 'exception' => 0));
        $result = $client->__soapCall('registrarRetiro', array(
            'registrarRetiro' => array(
                'retiroTO' => array(
                    'ExtensionData' => '',
                    'CodigoAdmision' => $codigoAdmision,
                    'ClienteRemitente' => get_option('correoschile_codigoSAP', ''),
                    'CentroRemitente' => '',
                    'NombreRemitente' => get_option('correoschile_nombre', ''),
                    'DireccionRemitente' => get_option('correoschile_direccion', ''),
                    'PaisRemitente' => '056',
                    'CodigoPostalRemitente' => '',
                    'ComunaRemitente' => get_option('correoschile_comuna', ''),
                    'RutRemitente' => '',
                    'PersonaContactoRemitente' => get_option('correoschile_nombre', ''),
                    'TelefonoContactoRemitente' => get_option('correoschile_telefono', ''),
                    'FechaRetiro' => $fecha,
                    'HoraDesde' => $horaDesde,
                    'HoraHasta' => $horaHasta,
                ),
                'usuario' => trim(get_option('correoschile_usuario_api', '')), 
                'contrasena' => trim(get_option('correoschile_contrasena_api', ''))
            )), null, null);
        return $result->registrarRetiroResult;
    }
    catch (SoapFault $e) {
        throw new Exception($e->getMessage(), 0, $e);
    }
    catch (Exception $e) {
        throw new Exception('Ocurio un errror registrar el Retiro.', 0, $e);
    }
}