<?php

function correoschile_ajax_sucursales() 
{
    if ($_SERVER['REQUEST_METHOD'] === 'POST') 
    {
        try 
        {
            $codigoComuna = filter_input(INPUT_POST, 'codigoComuna');
            $sucursales = correoschile_sucursalesPorComuna($codigoComuna);
            header('http/1.1 200 OK');
            header('Content-Type: application/json; charset=UTF8');
            echo json_encode($sucursales);
            exit();
        } 
        catch( SoapFault $e ) 
        {
            header('http/1.1 500 Internal Server Error');
            header('Content-Type: application/json; charset=UTF8');
            die(json_encode(array('message' => $e->getMessage())));
        }    
    } 
    else 
    {
        header('http/1.1 500 Internal Server Error');
        header('Content-Type: application/json; charset=UTF8');
        die(json_encode(array('message' => 'Este método solo puede ser invocado con POST')));
    }    
}

function correoschile_sucursales()
{
    $wsdl = trim(get_option('correoschile_ws_sucursal', ''));
    if($wsdl !== '' && substr_compare(strtolower($wsdl), '?wsdl', -strlen('?wsdl')) < 0){
        $wsdl .= '?wsdl'; 
    }
    try
    {
        $client = new SoapClient($wsdl, array('trace' => 1, 'exception' => 0));
        $result = $client->__soapCall("listarTodasLasSucursales", array(
            'listarTodasLasSucursales' => array(
                'usuario' => trim(get_option('correoschile_usuario_api')),
                'contrasena' => trim(get_option('correoschile_contrasena_api'))
            )), null, null);
        return $result->listarTodasLasSucursalesResult->SucursalTO;
    }
    catch (Exception $e) {
        throw new Exception('Ocurio un errror intentando obtener las sucursales.', 0, $e);
    }
}

function correoschile_nombreDeSucursal($codigoComuna, $codigoSucursal)
{
    try
    {
        $sucursalObtenida = null;
        $sucursales = correoschile_sucursalesPorComuna($codigoComuna);
        if(is_array($sucursales)){
            foreach($sucursales as $sucursal){
                $iataOficina = $sucursal->IataOficina;
                $descripcionOficina = trim($sucursal->DescripcionOficina);
                if($iataOficina !== $codigoSucursal && $descripcionOficina !== $codigoSucursal)
                    continue;
                $sucursalObtenida = $sucursal;
                break;
            }
        } else{
            $iataOficina = $sucursales->IataOficina;
            $descripcionOficina = trim($sucursales->DescripcionOficina);
            if($iataOficina === $codigoSucursal || $descripcionOficina === $codigoSucursal)
                $sucursalObtenida = $sucursales;
        }
        return $sucursalObtenida;
    }
    catch(Exception $e)
    {
        return null;
    }
}

function correoschile_sucursalesPorComuna($codigoComuna)
{
    $wsdl = trim(get_option('correoschile_ws_sucursal', ''));
    if($wsdl !== '' && substr_compare(strtolower($wsdl), '?wsdl', -strlen('?wsdl')) < 0){
        $wsdl .= '?wsdl';
    }
    try
    {
        $client = new SoapClient($wsdl, array('trace' => 1, 'exception' => 0));
        $result = $client->__soapCall('listarSucursalesSegunComuna', array(
            'listarSucursalesSegunComuna' => array(
                'usuario' => trim(get_option('correoschile_usuario_api')),
                'contrasena' => trim(get_option('correoschile_contrasena_api')),
                'codigoComuna' => $codigoComuna
            )), null, null);
        return $result->listarSucursalesSegunComunaResult->SucursalTO;
    }
    catch (Exception $e) {
        throw new Exception('Ocurio un errror intentando obtener las sucursales.', 0, $e);
    }
}