<?php
function correoschile_ajax_generar_manifiesto() {
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        try {
            $order_ids = filter_input(INPUT_POST, 'order_ids');
            if(is_null($order_ids))
                throw new Exception('No se proporciono la variable "order_ids"');
            
            $ids = explode(',', $order_ids);
            $envios = array();
            $n = 1;
            foreach($ids as $id) {
                if($id === '')
                    continue;
                $order = wc_get_order(intval($id));
                if(is_bool($order))
                    continue;
                $estado = $order->get_status();
                if($estado !== 'processing')
                    continue;
                $envio = correoschile_obtenerEnvio($id);
                if(is_null($envio)) 
                    continue;
                if(is_null($envio->numeroEnvio))
                    continue;
                //if(is_null($envio->codigoRetiro))
                //    continue;
                switch ($envio->codigoServicio) {
                    case '24': $producto = 'PAQUETE EXPRESS DOMICILIO'; break;
                    case '07': $producto = 'PAQUETE EXPRESS SUCURSAL'; break;
                }
                array_push($envios, array(
                    'n' => $n, 
                    'producto' => $producto, 
                    'destinatario' => $order->get_shipping_first_name() . ' ' . $order->get_shipping_last_name(), 
                    'comuna' => $order->get_shipping_city(), 
                    'referencia' => $envio->numeroReferencia, 
                    'seguimiento' => $envio->numeroEnvio, 
                    'bultos' => $envio->numeroTotalPiezas));
                $n++;
            }
            
            /* ESTE CÓDIGO PUEDE SER USADO PARA PRUEBAS
            $envios = array();
            for($i = 1; $i <= 50; $i++)
            {
                array_push($envios, array('n' => $i, 
                    'producto' => 'PAQUETE EXPRESS DOMICILIO', 
                    'destinatario' => 'Destinatario ' . strval($i) , 
                    'comuna' => 'Comuna ' . strval($i), 
                    'referencia' => 'referencia' . strval($i),
                    'seguimiento' => 'Seguimiento' . strval($i),
                    'bultos' => 1));
            }
            */
            
            if (count($envios) === 0){
                header('http/1.1 500 Internal Server Error');
                header('Content-Type: application/json; charset=UTF8');
                die(json_encode(array('message' => 'No hay envíos para incluir en el manifiesto')));
            } else {
                $numeroManifiesto = correoschile_generarManifiesto_PDF($envios);
                
                $uploadDir   = wp_upload_dir();
                $baseUrl = $uploadDir['baseurl'];
                $baseUrl .= '/correoschile_manifiestos/';
                $link = $baseUrl . $numeroManifiesto;
                header('http/1.1 200 OK');
                header('Content-Type: application/json; charset=UTF8');
                echo json_encode(array('link' => $link));
                exit();
            }
        } 
        catch (Exception $e) {
            header('http/1.1 500 Internal Server Error');
            header('Content-Type: application/json; charset=UTF8');
            die(json_encode(array('message' => $e->getMessage())));
        }
    } else {
        header('http/1.1 500 Internal Server Error');
        header('Content-Type: application/json; charset=UTF8');
        die(json_encode(array('message' => 'Este método solo puede ser invocado con POST')));
    }       
}
function correoschile_generarManifiesto_PDF($envios) {
    try {
        $html = correoschile_generarManifiesto_Html($envios);
        require_once 'dompdf/autoload.inc.php';
        $dompdf = new Dompdf\Dompdf();
        $dompdf->set_paper('Letter', 'portrait');
        $dompdf->loadHtml(utf8_decode($html));
        $dompdf->render();
        $output = $dompdf->output();
        $numeroManifiesto = date('Ymd') . get_option('correoschile_codigoSAP','');
        
        $i = 0;
        $fileName = $numeroManifiesto . '.pdf';
        
        $uploadDir   = wp_upload_dir();
        $baseDir = $uploadDir['basedir'];
        $baseDir .= '/correoschile_manifiestos';
        if(!file_exists($baseDir))
        {
            wp_mkdir_p($baseDir);
        }
        $fullFileName = $baseDir . '/' . $fileName;
        while(file_exists($fullFileName)){
            $i++;
            $fileName = $numeroManifiesto . '_' . strval($i) . '.pdf';
            $fullFileName = $baseDir . '/' . $fileName;
        }
        file_put_contents($fullFileName, $output);
        return $fileName;
    } 
    catch (Exception $ex) {
        throw new Exception('Ocurrio un error intentando generar el PDF con el manifiesto.');
    }
}
function correoschile_generarManifiesto_Html($envios){
    $fila = 0;
    $filas = 14;
    $pagina = 0;
    $paginas = intval(count($envios) / $filas) + (count($envios) % $filas > 0 ? 1 : 0);
    
    require 'picqer/vendor/autoload.php';
    $barCodeGenerator = new \Picqer\Barcode\BarcodeGeneratorPNG();
    
    $html = correoschile_generarManifiesto_InicioHtml();
    foreach($envios as $envio){
        $fila++;
        if($fila === 1){ 
            $html .= correoschile_generarManifiesto_InicioPaginaHtml();
            $html .= correoschile_generarManifiesto_InicioTablaHtml();
        }
        $html .= correoschile_generarManifiesto_FilaTablaHtml($barCodeGenerator, $envio);
        if($fila === $filas){
            $fila = 0;
            $pagina++;
            $html .= correoschile_generarManifiesto_FinTablaHtml();
            $html .= correoschile_generarManifiesto_PiePaginaHtml($pagina, $paginas);
        }
    }
    if($fila > 0){
        $pagina++;
        $html .= correoschile_generarManifiesto_FinTablaHtml();
        $html .= correoschile_generarManifiesto_PiePaginaHtml($pagina, $paginas);        
    }
    $html .= correoschile_generarManifiesto_FinHtml();
    return $html;

}
function correoschile_generarManifiesto_InicioHtml(){
    return '<html>'
    . '<head>'
    . '<meta charset="UTF-8">'
    . '<meta name="viewport" content="width=device-width, initial-scale=1.0">'
    . '<meta http-equiv="X-UA-Compatible" content="ie=edge">'
    . '<style>'
    . 'html { margin: 10mm 19mm; font-family: "Helvetica", "Arial", sans-serif; }'
    . 'table { border-collapse: collapse; width:100%; font-size:9pt; }'
    . '.tbl_header { border: 1.1pt solid #000; }'
    . '.tbl_body {  width:100%; border-top: 1.1pt solid #000; border-left: 1.1pt solid #000; }'
    . '.tbl_body th { font-size: 8pt; height: 5mm; background-color: #ccc; border-bottom: 1.1pt solid #000; border-right: 1.1pt solid #000; }'
    . '.tbl_body td { background-color: #fff; height: 11mm; font-size: 8pt; border-bottom: 1.1pt solid #000; border-right: 1.1pt solid #000; }'
    . '.tbl_footer { border-top: 1pt solid #000; border-left: 1.1pt solid #000; }'
    . '.tbl_footer th { font-size: 10pt; height: 6mm; background-color: #ccc; border-bottom: 1.1pt solid #000; border-right: 1.1pt solid #000; }'
    . '.tbl_footer td { background-color: #fff; font-size: 10pt; border-bottom: 1.1pt solid #000; border-right: 1.1pt solid #000; }'
    . '</style>'
    . '</head>'
    . '<body>';
}
function correoschile_generarManifiesto_InicioPaginaHtml() {
    $rutCliente = get_option('correoschile_rut','');
    $cuentaCliente = get_option('correoschile_codigoSAP','');
    $numeroManifiesto = date('Ymd') . $cuentaCliente;
    $razonSocial = get_option('correoschile_nombre_tienda','');
    $fechaCreacion = '';
    $comuna = get_option('correoschile_comuna','');
    $usuario = 'WEB SERVICE';
        
    return '<center><h3 style="font-size:13pt; margin: 0;">MANIFIESTO RESUMEN</h4></center>'
    . '<table class="tbl_header">'
    . '<tr>'
    . '<td style="width:44mm;" rowspan="4" align="center">'
    . '<img width="150" height="27" src="data:image/png;base64,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"/>'
    . '</td>'
    . '<td style="width:26mm; height:6mm;">Rut:</td>'
    . '<td style="width:37mm;">' . $rutCliente . '</td>'
    . '<td style="width:33mm;">N&uacute;mero Manifiesto:</td>'
    . '<td>' . $numeroManifiesto . '</td>'
    . '</tr>'
    . '<tr>'
    . '<td style="height: 6mm;">Raz&oacute;n Social:</td>'
    . '<td>' . $razonSocial . '</td>'
    . '<td>Fecha Creaci&oacute;n:</td>'
    . '<td>' . $fechaCreacion .' </td>'
    . '</tr>'
    . '<tr>'
    . '<td style="height: 6mm">Cuenta Cliente:</td>'
    . '<td>' . $cuentaCliente . '</td>'
    . '<td>Comuna:</td>'
    . '<td>' . $comuna . '</td>'
    . '</tr>'
    . '<tr>'
    . '<td style="height: 6mm;">Usuario:</td>'
    . '<td colspan="3">' . $usuario . '</td>'
    . '</tr>'
    . '</table>';
}
function correoschile_generarManifiesto_InicioTablaHtml(){
    return '<table class="tbl_body" style="margin-top: 2.5mm;">'
    . '<thead>'
    . '<tr>'
    . '<th style="width:11mm;">N&deg;</th>'
    . '<th>PRODUCTO</th>'
    . '<th style="width:30mm; align:left;">DESTINATARIO</th>'
    . '<th style="width:26mm; align:left;">COMUNA</th>'
    . '<th style="width:24mm; align:left;">REFERENCIA</th>'
    . '<th style="width:33mm; align:left;">SEGUIMIENTO</th>'
    . '<th style="width:11mm; align:left;">BULTOS</th>'
    . '</tr>'
    . '</thead>'
    . '<tbody>';
}
function correoschile_generarManifiesto_FilaTablaHtml($barCodeGenerator, $envio){
    return '<tr>'
    . '<td align="right">' . $envio['n'] . '</td>'
    . '<td>' . $envio['producto'] . '</td>'
    . '<td>' . $envio['destinatario'] . '</td>'
    . '<td>' . $envio['comuna'] . '</td>'
    . '<td>' . $envio['referencia'] . '</td>'
    . '<td align="center">'
    . '<img src="data:image/png;base64,' . base64_encode($barCodeGenerator->getBarcode($envio['seguimiento'], $barCodeGenerator::TYPE_CODE_128)) . '" width="120">'
    . '<br><small style="">' . $envio['seguimiento'] . '</small>'
    . '</td>'
    . '<td align="right">' . $envio['bultos'] . '</td>'
    . '</tr>';
}
function correoschile_generarManifiesto_FinTablaHtml() {
    return '</tbody></table>';
}
function correoschile_generarManifiesto_PiePaginaHtml($pagina, $paginas) {
    return '<table class="tbl_footer" style="margin-top: 2.5mm;">'
    . '<tr>'
    . '<th style="width:59mm;">CLIENTE</th>'
    . '<th style="width:64mm;">TRANSPORTE</th>'
    . '<th>ADMISI&Oacute;N CORREOS</th>'
    . '</tr><tr><td style="height: 24mm;"></td><td></td><td></td></tr>'
    . '<tr>'
    . '<th>Nombre, RUT, Firma y Fecha</th>'
    . '<th>Nombre, RUT, Firma y Fecha</th>'
    . '<th>Nombre, RUT, Firma y Fecha</th>'
    . '</tr>'
    . '</table>'
    . '<table width="100%" style="page-break-after: always;">'
    . '<tr><td align="right">P&aacute;gina ' . $pagina . '/' . $paginas . '</td></tr>'
    . '</table>';
}
function correoschile_generarManifiesto_FinHtml(){
    return '</body></html>';
}


