<?php

function correoschile_crear_tabla_envios(){
    global $wpdb;
    $table = $wpdb->prefix . 'correoschile_envios';
    if($wpdb->get_var("show tables like '$table'") != $table) { 
	$charset_collate = $wpdb->get_charset_collate();
        $sql = "CREATE TABLE {$table} (
                order_id BIGINT(20) NOT NULL,
                fechaCreacion DATETIME NOT NULL,
                codigoServicio VARCHAR(2) NOT NULL,
                numeroTotalPiezas INT NOT NULL,
                kilos VARCHAR(7) NOT NULL,
                volumen VARCHAR(7) NOT NULL,
                codigoAdmision VARCHAR(60) NULL,
                numeroReferencia VARCHAR(24) NULL,
                formatoEtiqueta VARCHAR(4) NULL,
                numeroEnvio VARCHAR(60) NULL,
                codigoRetiro INT NULL,
                fechaRetiro VARCHAR(10) NULL,
                horaRetiroDesde VARCHAR(5) NULL,
                horaRetiroHasta VARCHAR(5) NULL,
                error VARCHAR(255) NULL,
                PRIMARY KEY (order_id)
        ) $charset_collate;";
        require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
        dbDelta( $sql );
    }
}

function correoschile_eliminar_tabla_envios(){
    global $wpdb;
    $table_name = $wpdb-> prefix . 'correoschile_envios';
    $wpdb->query("DROP TABLE IF EXISTS $table_name");
}

function correoschile_agregarEnvio($order_id, $codigoServicio, $kilos, $volumen) {
    global $wpdb;
    $table = $wpdb->prefix . 'correoschile_envios';
    $time = current_time( 'mysql' );
    $wpdb->insert($table, array(
        'order_id' => $order_id,
        'codigoServicio' => $codigoServicio,
        'kilos' => $kilos,
        'volumen' => $volumen,
        'numeroTotalPiezas' => 1,
        'fechaCreacion' => $time
    ));
}

function correoschile_actualizarEnvio_InfoAdmision($order_id, $codigoAdmision, $numeroReferencia, $numeroEnvio, $formatoEtiqueta) {
    global $wpdb;
    $table = $wpdb->prefix . 'correoschile_envios';
    $wpdb->update($table, array(
        'codigoAdmision' => $codigoAdmision,
        'numeroReferencia' => $numeroReferencia,
        'numeroEnvio' => $numeroEnvio,
        'formatoEtiqueta' => $formatoEtiqueta,
        'error' => ''
    ), array('order_id' => $order_id));
}

function correoschile_actualizarEnvio_InfoRetiro($order_id, $codigoRetiro, $fechaRetiro, $horaRetiroDesde, $horaRetiroHasta) {
    global $wpdb;
    $table = $wpdb->prefix . 'correoschile_envios';
    $wpdb->update($table, array(
        'codigoRetiro' => $codigoRetiro,
        'fechaRetiro' => $fechaRetiro,
        'horaRetiroDesde' => $horaRetiroDesde,
        'horaRetiroHasta' => $horaRetiroHasta,
        'error' => ''
    ), array('order_id' => $order_id));
}

function correoschile_actualizarEnvio_InfoError($order_id, $error) {
    global $wpdb;
    $table = $wpdb->prefix . 'correoschile_envios';
    $wpdb->update($table, array(
        'error' => $error
    ), array('order_id' => $order_id));
}

function correoschile_eliminarEnvio($order_id) {
    global $wpdb;
    $table = $wpdb->prefix . 'correoschile_envios';
    $wpdb->delete($table, array('order_id' => $order_id));
}

function correoschile_obtenerEnvio($order_id) {
    $envios = correoschile_buscarEnvios('','',$order_id,'','');
    if(count($envios) === 1)
        return $envios[0];
    return null;
}

function correoschile_buscarEnvios($fechaDesde = '', $fechaHasta = '', $order_id = '', $conEtiqueta = '', $conRetiro = '') {
    global $wpdb;
    $fechaDesde = is_string($fechaDesde) && preg_match("/^(0[1-9]|[1-2][0-9]|3[0-1])-(0[1-9]|1[0-2])-[0-9]{4}$/", $fechaDesde) ? $fechaDesde : '';
    $fechaHasta = is_string($fechaHasta) && preg_match("/^(0[1-9]|[1-2][0-9]|3[0-1])-(0[1-9]|1[0-2])-[0-9]{4}$/", $fechaHasta) ? $fechaHasta : '';
    $conEtiqueta = is_string($conEtiqueta) && ($conEtiqueta === 'S' || $conEtiqueta === 'N') ? $conEtiqueta : '';
    $conRetiro = is_string($conRetiro) && ($conRetiro === 'S' || $conRetiro === 'N') ? $conRetiro : '';
    
    $table = $wpdb->prefix . 'correoschile_envios';
    $sql = "SELECT order_id "
               . ",fechaCreacion"
               . ",codigoServicio"
               . ",numeroTotalPiezas"
               . ",kilos"
               . ",volumen"
               . ",codigoAdmision"
               . ",numeroReferencia"
               . ",formatoEtiqueta"
               . ",numeroEnvio"
               . ",codigoRetiro"
               . ",fechaRetiro"
               . ",horaRetiroDesde"
               . ",horaRetiroHasta"
               . ",error"
        . " FROM $table ";
    $where = '';
    if($order_id !== '') $where .= ($where === '' ? ' WHERE ' : ' AND ') . " order_id = " . $order_id . " ";
    if($fechaDesde !== '') { $where .= ($where === '' ? ' WHERE ' : ' AND ') . " fechaCreacion >= '" . correoschile_formatearFecha($fechaDesde) . " 00:00:00'"; }
    if($fechaHasta !== '') { $where .= ($where === '' ? ' WHERE ' : ' AND ') . " fechaCreacion <= '" . correoschile_formatearFecha($fechaHasta) . " 23:59:59'"; }
    if($conEtiqueta === 'S') { $where .= ($where === '' ? ' WHERE ' : ' AND ') . " codigoAdmision IS NOT NULL "; }
    if($conEtiqueta === 'N') { $where .= ($where === '' ? ' WHERE ' : ' AND ') . " codigoAdmision IS NULL "; }
    if($conRetiro === 'S') { $where .= ($where === '' ? ' WHERE ' : ' AND ') . " codigoRetiro IS NOT NULL "; }
    if($conRetiro === 'N') { $where .= ($where === '' ? ' WHERE ' : ' AND ') . " codigoRetiro IS NULL "; }
         
    $envios = $wpdb->get_results($sql . $where);
    return $envios;
}

function correoschile_formatearFecha($fecha) {
    $fecha = explode('-', $fecha);
    return $fecha[2] . '-' . $fecha[1] . '-' . $fecha[0];
}
