var correoschile_cart = function(prms){
    _ths = this;
    this.cargando = false;
    this.prms = prms;
    this.iniciar =  function(){
        let ok = false;
        let shipping_methods = jQuery('.woocommerce-shipping-methods');
        if (shipping_methods.length > 0) {
            _ths.cargando = true;
            for(let i = 0; i < shipping_methods.length; i++){
                if(jQuery('li', shipping_methods[i]).length === 1 && jQuery('li input', shipping_methods[i]).val() === 'correoschile_shipping_method') {
                    ok = true;
                    break;
                }
                if (jQuery('li input:checked', shipping_methods[i]).val() === 'correoschile_shipping_method') {
                    ok = true;
                    break;
                }
            }
        }
        if(!ok){
            shipping_methods = jQuery('.shipping_method');
            if (shipping_methods.length > 0) {
                _ths.cargando = true;
                if(shipping_methods.length === 1 && jQuery(shipping_methods).val() === 'correoschile_shipping_method'){
                    ok = true;
                }
                if (jQuery('.shipping_method:checked').val() === 'correoschile_shipping_method'){
                    ok = true;        
                }
            }
        }
        if(ok) {
            _ths.activarPlugin();
        }
    };
    this.activarPlugin = function(){
        _ths.realizarTransformaciones();
        _ths.establecerComportamientoRadios();
        _ths.establecerComunasAlCambiarPais();
        _ths.establecerComunasAlCambiarRegiones();
        _ths.establecerSucursalesAlCambiarComunas();
        _ths.establecerNombreSucursalAlCambiarSucursales();
        _ths.restablecerValores();
    };
    this.realizarTransformaciones = function() {
        jQuery('#calc_shipping_country_field').before('<input type="hidden" name="shipping_calculator" id="shipping_calculator" value="carrito"/>');
        jQuery('#calc_shipping_country_field').after('<p id="calc_shipping_tipoDespacho_field" class="form-row form-row-wide" style="display:none;"></p>');
        let html = '<ul style="list-style: none; margin:0;">';
        html += '<li>';
        html += '<input type="radio" name="calc_shipping_tipoDespacho" id="ped" value="24"><label style="display:inline;" for="ped">Despacho a Domicilio</label>';
        html += '<li>';
        html += '<input type="radio" name="calc_shipping_tipoDespacho" id="pes" value="07"><label style="display:inline;" for="pes">Despacho a Sucursal</label>';
        html += '</li>';
        jQuery('#calc_shipping_tipoDespacho_field').append(html);
        jQuery('#calc_shipping_city_field').append('<div id="calc_shipping_comuna_container" style="display:none;"><select id="calc_shipping_comuna" name="calc_shipping_comuna" style="width: 100%"></select><span style="color:red;" id="calc_shipping_comuna_msg"></span></div>');
        jQuery('#calc_shipping_comuna').select2({ width: 'resolve', placeholder: 'Comuna' });
        jQuery('#calc_shipping_city_field').after('<p id="calc_shipping_sucursal_field" class="form-row form-row-wide" style="display:none;"><select style="width: 100%" id="calc_shipping_sucursal" name="calc_shipping_sucursal"></select><span style="color:red;" id="calc_shipping_sucursal_msg"></span></p>');
        jQuery('#calc_shipping_sucursal').select2({ width: 'resolve', placeholder: 'Sucursal' });
        jQuery('#calc_shipping_sucursal_field').after('<p id="calc_shipping_direccion_field" class="form-row form-row-wide" style="display:none"><input type="text" class="input-text" maxlenght="60" value="" placeholder="Dirección" name="calc_shipping_direccion" id="calc_shipping_direccion"></p>');
    };
    this.restablecerValores = function() {
        if(_ths.prms && _ths.prms.tipoDespacho && _ths.prms.tipoDespacho === '07')
            jQuery('#pes').attr('checked','checked');
        else 
            jQuery('#ped').attr('checked','checked');
        if(_ths.prms && _ths.prms.direccion && _ths.prms.direccion !== '')
            jQuery('#calc_shipping_direccion').val(_ths.prms.direccion);
        
        jQuery('#calc_shipping_comuna').attr('disabled','disabled');
        jQuery('#calc_shipping_sucursal').attr('disabled','disabled');
        let region = jQuery('#calc_shipping_state').val();
        let comuna = jQuery('#calc_shipping_city').val();
        let direccion = jQuery('#calc_shipping_direccion').val();
        if(region !== ''){
            _ths.cargarComunas(region, function() {
                if(comuna !== '') {
                    jQuery('#calc_shipping_comuna option').each(function(i, opt){
                        if(jQuery(opt).text() === comuna){
                            jQuery('#calc_shipping_comuna').val(jQuery(opt).val());
                            return false;
                        }
                    });
                    _ths.cargarSucursales(jQuery('#calc_shipping_comuna').val(), function() {
                        if(jQuery('#pes').is(':checked') && direccion !== ''){
                            jQuery('#calc_shipping_sucursal option').each(function(i, opt){
                                if(jQuery(opt).text() === direccion) {
                                    jQuery('#calc_shipping_sucursal').val(jQuery(opt).val());
                                    return false;
                                }
                            });
                            _ths.establecerVisualizacionDeControles();
                        } else {
                            _ths.establecerVisualizacionDeControles();
                        }
                    });
                } else {
                    _ths.establecerVisualizacionDeControles();        
                }
            });
        } else {
            _ths.establecerVisualizacionDeControles();
        };
    };
    this.establecerComunasAlCambiarPais = function(){
        jQuery('#calc_shipping_country').change(function() {
            jQuery('#calc_shipping_comuna').attr('disabled','disabled');
            jQuery('#calc_shipping_sucursal').attr('disabled','disabled');
            _ths.establecerVisualizacionDeControles(); 
        });
    };
    this.establecerComportamientoRadios = function(){
        jQuery('#ped').on('click', function() { 
            if(_ths.cargando)
                return; 
            _ths.establecerVisualizacionDeControles(); 
        });
        jQuery('#pes').on('click', function() { 
            if(_ths.cargando)
                return; 
            _ths.establecerVisualizacionDeControles(); 
        });
    };
    this.establecerVisualizacionDeControles = function(){
        if(jQuery('#calc_shipping_country').val() === 'CL') {
            jQuery('#calc_shipping_tipoDespacho_field').show();
            jQuery('#calc_shipping_city').hide();
            jQuery('#calc_shipping_comuna_container').show();
            jQuery('#calc_shipping_sucursal_field').hide();
            jQuery('#calc_shipping_direccion_field').hide();
            var tipoEnvio = jQuery('input:radio[name=calc_shipping_tipoDespacho]:checked').val();
            if(tipoEnvio) {
                if(tipoEnvio === '24'){ jQuery('#calc_shipping_direccion_field').show(); }
                if(tipoEnvio === '07'){ jQuery('#calc_shipping_sucursal_field').show(); }
            }
            jQuery('#calc_shipping_postcode').hide();           
        } else {
            jQuery('#calc_shipping_tipoDespacho_field').hide();
            jQuery('#calc_shipping_comuna_container').hide();
            jQuery('#calc_shipping_city').show();
            jQuery('#calc_shipping_comuna_container').hide();
            jQuery('#calc_shipping_sucursal_field').hide();
            jQuery('#calc_shipping_postcode').show();
        }
        _ths.cargando = false;
    };
    this.establecerComunasAlCambiarRegiones = function(){
        jQuery('#calc_shipping_state').change(function() {
            if(_ths.cargando)
                return;
            jQuery('#calc_shipping_city').val('');
            jQuery('#calc_shipping_comuna').attr('disabled','disabled');
            jQuery('#calc_shipping_sucursal').attr('disabled','disabled');
            _ths.cargarComunas(jQuery('#calc_shipping_state').val());
        });
    };
    this.cargarComunas = function(region, fx) {
        if(!region || region === '')
            return;
        jQuery('#calc_shipping_sucursal').attr('disabled','disabled');
        jQuery('#calc_shipping_sucursal').empty();
        jQuery('#calc_shipping_comuna').empty();
        jQuery('#calc_shipping_comuna').append('<option value=""></option>');
        jQuery('.cart_totals').block({ message: null, overlayCSS: { backgroundColor: '#fff', opacity: 0.6, cursor: 'wait' } });
        jQuery.ajax({
            url: correoschile_var.url,
            dataType: 'json',
            type: 'post',
            data: { 'action': 'correoschile_comunas', 'nonce' : correoschile_var.nonce_comunas, 'region': region },
            success: function(comunas) {
                jQuery('#calc_shipping_comuna_msg').text('');
                jQuery(comunas).each(function(i, c) {
                    jQuery('#calc_shipping_comuna').append('<option value=' + String(c.Iata).trim() + '>' + String(c.NombreComuna).trim() + '</option>');
                });
                jQuery('.cart_totals').unblock();
                jQuery('#calc_shipping_comuna').removeAttr('disabled');
                if(_ths.isFunction(fx))
                    fx();
            },
            error: function(xhr) {
                if (xhr && xhr.responseJSON && xhr.responseJSON.message)
                    console.log(xhr.responseJSON.message);
                jQuery('#calc_shipping_comuna_msg').text('Ocurrio un error intentando cargar las comunas.');
                jQuery('.cart_totals').unblock();
                if(_ths.isFunction(fx))
                    fx();
            }
        });
    };
    this.establecerSucursalesAlCambiarComunas =  function(){
        jQuery('#calc_shipping_comuna').change(function(){
            if(_ths.cargando)
                return;
            jQuery('#calc_shipping_city').val(jQuery('#calc_shipping_comuna option:selected').text());
            _ths.cargarSucursales(jQuery('#calc_shipping_comuna').val());
        });
    };
    this.cargarSucursales = function(codigoComuna, fx){
        if(!codigoComuna || codigoComuna === '')
            return;
        jQuery('#calc_shipping_sucursal').empty();
        jQuery('#calc_shipping_sucursal').append('<option value=""></option>');
        jQuery('.cart_totals').block({ message: null, overlayCSS: { backgroundColor: '#fff', opacity: 0.6, cursor: 'wait' } });
        jQuery.ajax({
            url: correoschile_var.url,
            dataType:'json',
            type:'post',
            data:{ 'action': 'correoschile_sucursales', 'nonce' : correoschile_var.nonce_sucursales, 'codigoComuna': codigoComuna },
            success:function(sucursales) {
                jQuery('#calc_shipping_sucursal_msg').text('');
                jQuery(sucursales).each(function(i, s) {
                    if(s.IataOficina)
                        jQuery('#calc_shipping_sucursal').append('<option value=' + String(s.IataOficina).trim() + '>' + String(s.DescripcionOficina).trim() + '</option>');
                });
                jQuery('.cart_totals').unblock();
                jQuery('#calc_shipping_sucursal').removeAttr('disabled');
                if(_ths.isFunction(fx))
                    fx();
            },
            error: function(xhr) {
                if (xhr && xhr.responseJSON && xhr.responseJSON.message)
                    console.log(xhr.responseJSON.message);
                jQuery('#calc_shipping_sucursal_msg').text('Ocurrio un error intentando cargar las sucursales.');
                jQuery('.cart_totals').unblock();
                if(_ths.isFunction(fx))
                    fx();
            }
        });
    };
    this.establecerNombreSucursalAlCambiarSucursales = function(){
        jQuery('#calc_shipping_sucursal').change(function() {
            if(_ths.cargando)
                return;
            jQuery('#calc_shipping_direccion').val(jQuery('#calc_shipping_sucursal option:selected').text());
        });
    };
    this.isFunction = function (n) {
        var t = typeof n;
        return t === "function" ? !0 : !1;
    };
    _ths.iniciar();
};
