<?php
if (! current_user_can ('manage_options'))
{
    wp_die(__('No tienes suficientes permisos para acceder a esta página.'));
}
if (!in_array('woocommerce/woocommerce.php', apply_filters('active_plugins', get_option('active_plugins')))) 
{
    wp_die(__('No has instalado wooCommerce o este se encuentra inactivo.'));
}
$guardado = false;
$s = filter_input(INPUT_GET, 's');
if(isset($s))
{
    $guardado = true;
}
?>
<div class="wrap">
    <h1 class="wp-heading-inline">Correos de Chile - Configuración</h1>
    <hr class="wp-header-end">
    <?php echo $guardado ? '<div id="message" class="updated inline"><p><strong>Tus ajustes se han guardado.</strong></p></div>' : ''; ?>
    <form method="POST" action="<?php echo admin_url('admin-post.php'); ?>" >
        <input type="hidden" name="action" value="correoschile_configuracion"/>
        
    <h2>Información de la tienda</h2>
    <table class="form-table" role="presentation">
        <tbody>
            <tr class="form-field form-required term-name-wrap">
		<th>
                    <label for="correoschile_nombre_tienda">Nombre Remitente (Tienda)</label>&nbsp;<abbr class="required" title="obligatorio">*</abbr>
		</th>
		<td>
                    <input name="correoschile_nombre_tienda" id="correoschile_nombre_tienda" type="text" value="<?php echo get_option('correoschile_nombre_tienda',''); ?>">
                    <p class="description"></p>
                </td>
            </tr>
            <tr class="form-field form-required term-name-wrap">
		<th>
                    <label for="correoschile_rut">Rut</label>&nbsp;<abbr class="required" title="obligatorio">*</abbr>
		</th>
		<td>
                    <input name="correoschile_rut" id="correoschile_rut" type="text" value="<?php echo get_option('correoschile_rut',''); ?>">
                    <p class="description"></p>
                </td>
            </tr>
            <tr class="form-field form-required term-name-wrap">
		<th>
                    <label for="correoschile_direccion">Dirección</label>&nbsp;<abbr class="required" title="obligatorio">*</abbr>
		</th>
		<td>
                    <input name="correoschile_direccion" id="correoschile_direccion" type="text" value="<?php echo get_option('correoschile_direccion',''); ?>">
                    <p class="description"></p>
                </td>
            </tr>            
            <tr class="form-field form-required term-name-wrap">
		<th>
                    <label for="correoschile_comuna">Comuna</label>&nbsp;<abbr class="required" title="obligatorio">*</abbr>
		</th>
		<td>
                    <input name="correoschile_comuna" id="correoschile_comuna" type="text" value="<?php echo get_option('correoschile_comuna',''); ?>">
                    <p class="description"></p>
                </td>
            </tr> 
            <tr class="form-field form-required term-name-wrap">
		<th>
                    <label for="correoschile_codigoPostal">Código Postal</label>&nbsp;<abbr class="required" title="obligatorio">*</abbr>
		</th>
		<td>
                    <input name="correoschile_codigoPostal" id="correoschile_codigoPostal" type="text" value="<?php echo get_option('correoschile_codigoPostal',''); ?>">
                    <p class="description"></p>
                </td>
            </tr>             
            <tr class="form-field form-required term-name-wrap">
		<th>
                    <label for="correoschile_nombre">Nombre</label>&nbsp;<abbr class="required" title="obligatorio">*</abbr>
		</th>
		<td>
                    <input name="correoschile_nombre" id="correoschile_nombre" type="text" value="<?php echo get_option('correoschile_nombre',''); ?>">
                    <p class="description"></p>
                </td>
            </tr> 
            <tr class="form-field form-required term-name-wrap">
		<th>
                    <label for="correoschile_telefono">Teléfono</label>&nbsp;<abbr class="required" title="obligatorio">*</abbr>
		</th>
		<td>
                    <input name="correoschile_telefono" id="correoschile_telefono" type="text" value="<?php echo get_option('correoschile_telefono',''); ?>">
                    <p class="description"></p>
                </td>
            </tr>             
            <tr class="form-field form-required term-name-wrap">
		<th>
                    <label for="correoschile_codigoSAP">Código Cliente</label>&nbsp;<abbr class="required" title="obligatorio">*</abbr>
		</th>
		<td>
                    <input name="correoschile_codigoSAP" id="correoschile_codigoSAP" type="text" value="<?php echo get_option('correoschile_codigoSAP',''); ?>">
                    <p class="description"></p>
                </td>
            </tr>             
        </tbody>
    </table>
    <hr>
    <h2>Credencial Servicios Web</h2>
    <table class="form-table" role="presentation">
        <tbody>
            <tr class="form-field form-required term-name-wrap" style="display: none;">
		<th>
                    <label for="correoschile_ambiente_api">Ambiente</label>&nbsp;<abbr class="required" title="obligatorio">*</abbr>
		</th>
		<td>
                    <?php $ambiente = get_option('correoschile_ambiente_api', 'CERTIFICACION'); ?>
                    <select name="correoschile_ambiente_api" id="correoschile_ambiente_api">
                        <option value="CERTIFICACION" <?php echo $ambiente === 'CERTIFICACION' ? 'selected' : ''; ?>>Certificación</option>
                        <option value="PRODUCCION" <?php echo $ambiente === 'PRODUCCION' ? 'selected' : ''; ?>>Producción</option>
                    </select>
                    <p class="description"></p>
                </td>
            </tr>
            <tr class="form-field form-required term-name-wrap">
		<th>
                    <label for="correoschile_usuario_api">Usuario</label>&nbsp;<abbr class="required" title="obligatorio">*</abbr>
		</th>
		<td>
                    <input name="correoschile_usuario_api" id="correoschile_usuario_api" type="text" value="<?php echo get_option('correoschile_usuario_api',''); ?>">
                    <p class="description"></p>
                </td>
            </tr>
            <tr class="form-field form-required term-name-wrap">
		<th>
                    <label for="correoschile_contrasena_api">Contraseña</label>&nbsp;<abbr class="required" title="obligatorio">*</abbr>
		</th>
		<td>
                    <input name="correoschile_contrasena_api" id="correoschile_contrasena_api" type="text" value="<?php echo get_option('correoschile_contrasena_api',''); ?>">
                    <p class="description"></p>
                </td>
            </tr>
        </tbody>
    </table>
    <hr>
    <h2>URL Servicios Web</h2>
    <table class="form-table" role="presentation">
        <tbody>
            <tr class="form-field form-required term-name-wrap">
		<th>
                    <label for="correoschile_ws_region">Regiones</label>&nbsp;<abbr class="required" title="obligatorio">*</abbr>
		</th>
		<td>
                    <input name="correoschile_ws_region" id="correoschile_ws_region" type="text" value="<?php echo get_option('correoschile_ws_region',''); ?>">
                    <p class="description">Este servicio se utiliza para completar el combo de regiones.</p>
                </td>
            </tr>
            <tr class="form-field form-required term-name-wrap">
		<th>
                    <label for="correoschile_ws_comuna">Comunas</label>&nbsp;<abbr class="required" title="obligatorio">*</abbr>
		</th>
		<td>
                    <input name="correoschile_ws_comuna" id="correoschile_ws_comuna" type="text" value="<?php echo get_option('correoschile_ws_comuna',''); ?>">
                    <p class="description">Este servicio se utiliza para completar el combo de comunas.</p>
                </td>
            </tr>            
            <tr class="form-field form-required term-name-wrap">
		<th>
                    <label for="correoschile_ws_sucursal">Sucursales</label>&nbsp;<abbr class="required" title="obligatorio">*</abbr>
		</th>
		<td>
                    <input name="correoschile_ws_sucursal" id="correoschile_ws_sucursal" type="text" value="<?php echo get_option('correoschile_ws_sucursal',''); ?>">
                    <p class="description">Este servicio se utiliza para completar el combo de sucursales.</p>
                </td>
            </tr>
            
            <tr class="form-field form-required term-name-wrap">
		<th>
                    <label for="correoschile_ws_normalizacion">Normalización</label>&nbsp;<abbr class="required" title="obligatorio">*</abbr>
		</th>
		<td>
                    <input name="correoschile_ws_normalizacion" id="correoschile_ws_normalizacion" type="text" value="<?php echo get_option('correoschile_ws_normalizacion',''); ?>">
                    <p class="description">Este servicio se utiliza para comprobar las direcciones y obtener el código postal.</p>
                </td>
            </tr>
            <tr class="form-field form-required term-name-wrap">
		<th>
                    <label for="correoschile_ws_tarificacion">Tarificación</label>&nbsp;<abbr class="required" title="obligatorio">*</abbr>
		</th>
		<td>
                    <input name="correoschile_ws_tarificacion" id="correoschile_ws_tarificacion" type="text" value="<?php echo get_option('correoschile_ws_tarificacion',''); ?>">
                    <p class="description">Este servicio se utiliza para calcular el costo de los envíos en base a la comuna de destino, peso y volumen de los productos.</p>
                </td>
            </tr>
            <tr class="form-field form-required term-name-wrap">
		<th>
                    <label for="correoschile_ws_etiquetas">Etiquetas</label>&nbsp;<abbr class="required" title="obligatorio">*</abbr>
		</th>
		<td>
                    <input name="correoschile_ws_etiquetas" id="correoschile_ws_etiquetas" type="text" value="<?php echo get_option('correoschile_ws_etiquetas',''); ?>">
                    <p class="description">Este servicio se utiliza para generar las etiquetas de sus pedidos.</p>
                </td>
            </tr>
            <tr class="form-field form-required term-name-wrap">
		<th>
                    <label for="correoschile_ws_retiro">Retiro</label>&nbsp;<abbr class="required" title="obligatorio">*</abbr>
		</th>
		<td>
                    <input name="correoschile_ws_retiro" id="correoschile_ws_retiro" type="text" value="<?php echo get_option('correoschile_ws_retiro',''); ?>">
                    <p class="description">Este servicio se utiliza para agendar el retiro de sus pedidos en su tienda.</p>
                </td>
            </tr>
            <tr class="form-field form-required term-name-wrap" style="display: none;">
		<th>
                    <label for="correoschile_ws_trazabilidad">Trazabilidad</label>
		</th>
		<td>
                    <input name="correoschile_ws_trazabilidad" id="correoschile_ws_trazabilidad" type="text" value="<?php echo get_option('correoschile_ws_trazabilidad',''); ?>">
                    <p class="description">Este servicio se utiliza para ver el estado de los enviós, * requiere una autorización adicional.</p>
                </td>
            </tr>
           
        </tbody>
    </table>
    <hr>
    <h2>Configuración adicional</h2>
    <table class="form-table" role="presentation">
        <tbody>
             <tr class="form-field form-required term-name-wrap">
		<th scope="row" class="titledesc">Método por defecto</th>
                <td class="forminp forminp-checkbox">
                    <fieldset>
                        <legend class="screen-reader-text"><span>Método por defecto</span></legend>
                        <label for="correoschile_default">
                        <input name="correoschile_default" id="correoschile_default" type="checkbox" <?php echo (get_option('correoschile_default','') === 'S' ? 'checked' : ''); ?> value="S"> Seleccionar a Correos de Chile como método de envío por defecto.</label> 
                        <p class="description">Utilice esta opción si desea que Correos de Chile sea su método de envío por defecto.</p>
                    </fieldset>
                </td>
            </tr>
             <tr class="form-field form-required term-name-wrap">
		<th scope="row" class="titledesc">Cargar regiones</th>
                <td class="forminp forminp-checkbox">
                    <fieldset>
                        <legend class="screen-reader-text"><span>Cargar regiones</span></legend>
                        <label for="correoschile_cargarRegiones">
                        <input name="correoschile_cargarRegiones" id="correoschile_cargarRegiones" type="checkbox" <?php echo (get_option('correoschile_cargarRegiones','') === 'S' ? 'checked' : ''); ?> value="S"> Permitir a Correos de Chile cargar las regiones.</label> 
                        <p class="description">Correos de Chile agregará en la listas de estados de Chile las regiones con su código ISO3166-2:CL. Si ya tiene las regiones cargadas o sí utiliza otro plugin que hace esto no use esta opción.</p>
                    </fieldset>
                </td>
            </tr>            
            <tr class="form-field form-required term-name-wrap">
		<th>
                    <label for="correoschile_formato_etiqueta">Formato Etiqueta</label>&nbsp;<abbr class="required" title="obligatorio">*</abbr>
		</th>
		<td>
                    <?php $formato_etiqueta = get_option('correoschile_formato_etiqueta', 'PDF'); ?>
                    <select name="correoschile_formato_etiqueta" id="correoschile_formato_etiqueta">
                        <option value="PDF" <?php echo $formato_etiqueta === 'PDF' ? 'selected' : ''; ?>>PDF</option>
                        <option value="PDFS" <?php echo $formato_etiqueta === 'PDFS' ? 'selected' : ''; ?>>PDF Small</option>
                        <option value="ZPL" <?php echo $formato_etiqueta === 'ZPL' ? 'selected' : ''; ?>>Impresora Zebra</option>
                    </select>
                    <p class="description">Formato en que será generada la etiqueta para los envíos.</p>
                </td>
            </tr>   
            <tr class="form-field form-required term-name-wrap">
		<th>
                    <label>Tarificar los envíos</label>
		</th>
                <td>
                    <fieldset>
			<ul>
                            <li>
                                <label><input name="correoschile_tarificar" value="S" type="radio" <?php echo (get_option('correoschile_tarificar','') === 'S' ? 'checked="checked"' : ''); ?>><strong>Sí</strong> (Por defecto, se sumará el costo de envío en el total del cliente)</label>
                            </li>
                            <li>
                                <label><input name="correoschile_tarificar" value="N" type="radio" <?php echo (get_option('correoschile_tarificar','') === 'N' ? 'checked="checked"' : ''); ?>><strong>No</strong> (Utilice esta opción cuando desee asumir el costo de envío y para el cliente sea gratuito)</label>
                            </li>
                        </ul>
                    </fieldset>
                </td>
            </tr>            
            <tr class="form-field form-required term-name-wrap">
		<th>
                    <label>No tarificar a partir de</label>
		</th>
                <td>
                    <input name="correoschile_no_tarificar" id="correoschile_no_tarificar" type="number" value="<?php echo get_option('correoschile_no_tarificar',''); ?>" placeholder="">
                    <p class="description">Utilice esta opción cuando desee ofrecer gratuitamente los envíos a partir de un total hacia arriba.</p>
                </td>
            </tr>            
            <tr class="form-field form-required term-name-wrap">
		<th>
                    <label>Marginar costo de envío</label>
		</th>
                <td>
                    <fieldset>
			<ul>
                            <li>
                                <label><input name="correoschile_marginar" value="" type="radio" <?php echo (get_option('correoschile_marginar','') === '' ? 'checked="checked"' : ''); ?>><strong>No</strong></label>
                            </li>                            
                            <li>
                                <label><input name="correoschile_marginar" value="P" type="radio" <?php echo (get_option('correoschile_marginar','') === 'P' ? 'checked="checked"' : ''); ?>><strong>Marginar un porcentaje</strong> (Para aumentar o disminuir el porcentaje del costo de envío)</label>
                            </li>
                            <li>
                                <label><input name="correoschile_marginar" value="V" type="radio" <?php echo (get_option('correoschile_marginar','') === 'V' ? 'checked="checked"' : ''); ?>><strong>Marginar un valor</strong> (Para sumar o restar al costo de envío)</label>
                            </li>
                            <li>
                                <input name="correoschile_marginar_valor" id="correoschile_marginar_valor" type="number" value="<?php echo get_option('correoschile_marginar_valor',''); ?>" placeholder="Valor a marginar">
                                <p class="description"></p>
                            </li>
                        </ul>
                    </fieldset>
                </td>
            </tr>            
            <tr class="form-field form-required term-name-wrap">
		<th scope="row" class="titledesc">Ordenar campos en CheckOut</th>
                <td class="forminp forminp-checkbox">
                    <fieldset>
                        <legend class="screen-reader-text"><span>Ordenar campos en CheckOut</span></legend>
                        <label for="correoschile_ordenarCamposCheckout">
                        <input name="correoschile_ordenarCamposCheckout" id="correoschile_ordenarCamposCheckout" type="checkbox" <?php echo (get_option('correoschile_ordenarCamposCheckout','') === 'S' ? 'checked' : ''); ?> value="S"> Activar ordenamiendo de campos en CheckOut</label> 
                        <p class="description">El orden de los campos en woocommerce no corresponde a la organización habitual en Chile (Region, Comuna, Dirección), utilice esta opción si desea que el plugin realice esta modificación.</p>
                    </fieldset>
                </td>
            </tr>
            <tr class="form-field form-required term-name-wrap">
		<th scope="row" class="titledesc">Ocultar empresa en CheckOut</th>
                <td class="forminp forminp-checkbox">
                    <fieldset>
                        <legend class="screen-reader-text"><span>Ocultar empresa en CheckOut</span></legend>
                        <label for="correoschile_ocultarCompanyField">
                        <input name="correoschile_ocultarCompanyField" id="correoschile_ordenarCamposCheckout" type="checkbox" <?php echo (get_option('correoschile_ocultarCompanyField','') === 'S' ? 'checked' : ''); ?> value="S"> Ocultar campo "Nombre de la empresa" en CheckOut</label> 
                        <p class="description">Activa esta opción si deseas ocultar los campos "Billing_Company" y "Shipping_Company" en el formulario de Checkout, insertaremos un css para que no se vean.</p>
                    </fieldset>
                </td>
            </tr>            
            <tr class="form-field form-required term-name-wrap">
		<th scope="row" class="titledesc">Modo Multitienda</th>
                <td class="forminp forminp-checkbox">
                    <fieldset>
                        <legend class="screen-reader-text"><span>Modo Multitienda</span></legend>
                        <label for="correoschile_calcularPorTienda">
                            <input name="correoschile_calcularPorTienda" id="correoschile_calcularPorTienda" type="checkbox" <?php echo (get_option('correoschile_calcularPorTienda','') === 'S' ? 'checked' : ''); ?> value="S"> Activar modo multitienda</label>&nbsp;<strong><span>(Sólo disponible con el plugin Dokan Lite)</span></strong>
                        <p class="description">Utilice esta opción si ha definido usuarios con la función "Vendor", de esta manera la tarificación se realizará en base a la comuna de cada uno de estos usuarios *(get_user_meta ['dokan_profile_settings'][0]['address']['city']).</p>
                    </fieldset>
                </td>
            </tr>            
        </tbody>
    </table>
    <div class="edit-tag-actions">
        <input type="submit" class="button button-primary" value="Actualizar">
    </div>
    </form>
</div>
