
function correoschile_envios(prms){
    var _ths = this;
    _ths.fecha = prms.fecha;
    _ths.strFecha = prms.strFecha;
    _ths.agendarHoy = prms.agendarHoy;
    this.confirmar = undefined;
    this.procesando = false;
    
    this.iniciar = function() {
        jQuery('.dtp').datepicker({ 
            closeText: 'Cerrar',
            prevText: '<Ant',
            nextText: 'Sig>',
            currentText: 'Hoy',
            monthNames: ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'],
            monthNamesShort: ['Ene', 'Feb', 'Mar', 'Abr', 'May', 'Jun', 'Jul', 'Ago', 'Sep', 'Oct', 'Nov', 'Dic'],
            dayNames: ['Domingo', 'Lunes', 'Martes', 'Miércoles', 'Jueves', 'Viernes', 'Sábado'],
            dayNamesShort: ['Dom', 'Lun', 'Mar', 'Mié', 'Juv', 'Vie', 'Sáb'],
            dayNamesMin: ['Do', 'Lu', 'Ma', 'Mi', 'Ju', 'Vi', 'Sá'],
            weekHeader: 'Sm',
            dateFormat: 'dd-mm-yy',
            firstDay: 1,
            isRTL: false,
            showMonthAfterYear: false,
            yearSuffix: ''
        });
        jQuery('.dtpr').datepicker({ 
            closeText: 'Cerrar',
            prevText: '<Ant',
            nextText: 'Sig>',
            currentText: 'Hoy',
            monthNames: ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'],
            monthNamesShort: ['Ene', 'Feb', 'Mar', 'Abr', 'May', 'Jun', 'Jul', 'Ago', 'Sep', 'Oct', 'Nov', 'Dic'],
            dayNames: ['Domingo', 'Lunes', 'Martes', 'Miércoles', 'Jueves', 'Viernes', 'Sábado'],
            dayNamesShort: ['Dom', 'Lun', 'Mar', 'Mié', 'Juv', 'Vie', 'Sáb'],
            dayNamesMin: ['Do', 'Lu', 'Ma', 'Mi', 'Ju', 'Vi', 'Sá'],
            weekHeader: 'Sm',
            dateFormat: 'dd-mm-yy',
            firstDay: 1,
            isRTL: false,
            showMonthAfterYear: false,
            yearSuffix: '',
            minDate: 0
        });
        jQuery('#aplicar').on('click', function(e) {
            let opcion = jQuery('#accion_masiva').val();
            if(opcion === 'generar_etiquetas'){
                let chks = jQuery('input[type=checkbox]:checked','#envios tbody');
                if(chks.length === 0) {
                    _ths.mostrar_mensaje('No se han seleccionado envíos.', 'Debes seleccionar al menos 1 envío para ejecutar esta acción.');
                    return;
                }
                _ths.mostrar_generador_etiquetas();
            }
            if(opcion === 'generar_manifiesto'){
                let chks = jQuery('input[type=checkbox]:checked','#envios tbody');
                if(chks.length === 0) {
                    _ths.mostrar_mensaje('No se han seleccionado envíos.', 'Debes seleccionar al menos 1 envío para generar el manifiesto.');
                    return;
                }
                _ths.mostrar_generador_manifiesto();
            }
            if(opcion === 'solicitar_retiro'){
                let chks = jQuery('input[type=checkbox]:checked','#envios tbody');
                if(chks.length === 0) {
                    _ths.mostrar_mensaje('No se han seleccionado envíos.', 'Debes seleccionar al menos 1 envío para solicitar retiro.');
                    return;
                }
                _ths.mostrar_solicitar_retiro();
            }            
        });
        
        jQuery('#btnSiGeneracionEtiquetas').on('click', function(event) {
            if(event.preventDefault) 
                event.preventDefault();
            jQuery('.contenido1', '#dlg_generador_etiquetas').hide();
            jQuery('.contenido2', '#dlg_generador_etiquetas').show();
            jQuery('#dlg_generador_etiquetas').dialog('option', 'title', 'Generando etiquetas');
            jQuery('.contenido2 strong', '#dlg_generador_etiquetas').text('Generando etiquetas...');
            
            setTimeout(function() {
                _ths.procesando = true;
                let chks = jQuery('input[type=checkbox]:checked','#envios tbody');
                for(var i = 0; i < jQuery(chks).length; i++){
                    let order_id = jQuery(chks[i]).attr('data-id');
                    jQuery.ajax({
                        url: correoschile_var.url,
                        dataType:'json',
                        type:'post',
                        beforeSend: function(){
                            jQuery('.contenido2 strong', '#dlg_generador_etiquetas').text('Generando etiquetas... ' + String(i) + ' de ' + String(chks.length));
                        },
                        data:{ 'action': 'correoschile_etiquetas', 'nonce' : correoschile_var.nonce_etiqueta, 'order_id': order_id },
                        success:function(data) {
                            let tr = jQuery(chks[i]).parent().parent();
                            let td = jQuery('td:nth-child(5)', tr);
                            jQuery(td).empty().append(data.html);
                            jQuery('td:nth-child(7)', tr).empty();
                        },
                        error: function(xhr) {
                            let tr = jQuery(chks[i]).parent().parent();
                            jQuery('td:nth-child(7)', tr).empty();
                            if (xhr && xhr.responseJSON && xhr.responseJSON.message){
                                jQuery('td:nth-child(7)', tr).text(xhr.responseJSON.message);
                            } else {
                                jQuery('td:nth-child(7)', tr).text('Ocurrio un error intentando generar la etiqueta');
                            }
                        },
                        async: false
                    });
                    if(_ths.procesando === false){
                        break;
                    }
                }
                jQuery('#dlg_generador_etiquetas').dialog('close');
            }, 400);
        });
        jQuery('#btnNoGeneracionEtiquetas').on('click', function(event){ 
            if(event.preventDefault) 
                event.preventDefault();
            jQuery('#dlg_generador_etiquetas').dialog('close');
        });
        jQuery('#btnCancelarGeneracionEtiquetas').on('click', function(event){
            if(event.preventDefault) 
                event.preventDefault();
            _ths.procesando = false;
            jQuery('#dlg_generador_etiquetas').dialog('close');
        });
        
        jQuery('#btnSiGeneracionManifiesto').on('click', function(event) {
            if(event.preventDefault) 
                event.preventDefault();
            jQuery('.mensaje', '#dlg_generador_manifiesto').empty().append('<span class="cch_loading">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; Por favor espere que el proceso termine para continuar navegando por el sitio.</span>');
            jQuery('#btnDescargarManifiesto', '#dlg_generador_manifiesto').hide();
            jQuery('#btnCerrarGeneracionManifiesto', '#dlg_generador_manifiesto').hide();
            jQuery('#btnDescargarManifiesto', '#dlg_generador_manifiesto').attr('href', '#');
            jQuery('.contenido1', '#dlg_generador_manifiesto').hide();
            jQuery('.contenido2', '#dlg_generador_manifiesto').show();
            jQuery('#dlg_generador_manifiesto').dialog('option', 'title', 'Generando Manifiesto');

            let chks = jQuery('input[type=checkbox]:checked','#envios tbody');
            setTimeout(function() {
                _ths.procesando = true;
                let order_ids = '';
                for(var i = 0; i < jQuery(chks).length; i++){
                    jQuery('.msg', '.cch_msg').text('Generando ' + String(i+1) + ' de ' + String(jQuery(chks).length));
                    let order_id = jQuery(chks[i]).attr('data-id');
                    if(order_ids !== '') order_ids += ',';
                    order_ids += order_id;
                }
                jQuery.ajax({
                    url: correoschile_var.url,
                    dataType:'json',
                    type:'post',
                    data:{ 'action': 'correoschile_manifiesto', 'nonce' : correoschile_var.nonce_manifiesto, 'order_ids': order_ids },
                    success:function(data) {
                        jQuery('.mensaje', '#dlg_generador_manifiesto').empty().append('<span>El manifiesto ha sido generado exitosamente.</span>');
                        jQuery('#btnDescargarManifiesto', '#dlg_generador_manifiesto').show();
                        jQuery('#btnCerrarGeneracionManifiesto', '#dlg_generador_manifiesto').show();
                        jQuery('#btnDescargarManifiesto', '#dlg_generador_manifiesto').attr('href', data.link);
                    },
                    error: function(xhr) {
                        if (xhr && xhr.responseJSON && xhr.responseJSON.message){
                            jQuery('.mensaje', '#dlg_generador_manifiesto').empty().append('<span style="color:red;">' + xhr.responseJSON.message + '</span>');
                        } else {
                            jQuery('.mensaje', '#dlg_generador_manifiesto').empty().append('<span style="color:red;">Ocurrio un error intentando generar la etiqueta</span>');
                        }
                    },
                    async: false
                });
            }, 400); 
        });
        jQuery('#btnNoGeneracionManifiesto').on('click', function(event){ 
            if(event.preventDefault) 
                event.preventDefault();
            jQuery('#dlg_generador_manifiesto').dialog('close');
        });
        jQuery('#btnCerrarGeneracionManifiesto').on('click', function(event){
            if(event.preventDefault) 
                event.preventDefault();
            _ths.procesando = false;
            jQuery('#dlg_generador_manifiesto').dialog('close');
        });
        
        jQuery('#btnSiSolicitarRetiro').on('click', function(event){ 
            if(event.preventDefault) 
                event.preventDefault();
            jQuery('.contenido1', '#dlg_solicitar_retiro').hide();
            jQuery('.contenido3', '#dlg_solicitar_retiro').hide();
            jQuery('.contenido2', '#dlg_solicitar_retiro').show();
            jQuery('#dlg_solicitar_retiro').dialog('option', 'title', 'Solicitud de retiro');
        });
        jQuery('#btnNoSolicitarRetiro').on('click', function(event){ 
            if(event.preventDefault) 
                event.preventDefault();
            jQuery('#dlg_solicitar_retiro').dialog('close');
        });
        jQuery('#btnContinuarSolicitarRetiro').on('click', function(event){
            if(event.preventDefault) 
                event.preventDefault();
            let esValida =_ths.validarSolicitudRetiro();
            if(esValida){
                jQuery('.contenido1', '#dlg_solicitar_retiro').hide();
                jQuery('.contenido2', '#dlg_solicitar_retiro').hide();
                jQuery('.contenido3', '#dlg_solicitar_retiro').show();
                jQuery('.contenido3 strong', '#dlg_solicitar_retiro').text('Solicitando retiros... ');
                setTimeout(function() {
                    _ths.procesando = true;
                    let chks = jQuery('input[type=checkbox]:checked','#envios tbody');
                    for(var i = 0; i < jQuery(chks).length; i++){
                        let order_id = jQuery(chks[i]).attr('data-id');
                        let horario = jQuery('input[name=horario]:checked').val();
                        let reAgendar = jQuery('#reAgendar', '#dlg_solicitar_retiro').is(':checked');
                        reAgendar = reAgendar ? 'S' : 'N';
                        let data = {
                            'action': 'correoschile_retiro', 
                            'nonce' : correoschile_var.nonce_retiro, 
                            'order_id': order_id,
                            'fecha': jQuery('#fechaRetiro', '#dlg_solicitar_retiro').val(),
                            'horaDesde': (horario === 'mañana' ? '09:00' : '15:00'),
                            'horaHasta': (horario === 'mañana' ? '13:00' : '17:30'),
                            'reAgendar': reAgendar
                        };
                        jQuery.ajax({
                            url: correoschile_var.url,
                            dataType:'json',
                            type:'post',
                            beforeSend: function(){
                                jQuery('.contenido3 strong', '#dlg_solicitar_retiro').text('Solicitando retiro... ' + String(i) + ' de ' + String(chks.length));
                            },
                            data: data,
                            success:function(data) {
                                let tr = jQuery(chks[i]).parent().parent();
                                let td = jQuery('td:nth-child(6)', tr);
                                jQuery(td).empty().append(data.retiro);
                                jQuery('td:nth-child(7)', tr).empty();
                            },
                            error: function(xhr) {
                                let tr = jQuery(chks[i]).parent().parent();
                                jQuery('td:nth-child(7)', tr).empty();
                                if (xhr && xhr.responseJSON && xhr.responseJSON.message){
                                    jQuery('td:nth-child(7)', tr).text(xhr.responseJSON.message);
                                } else {
                                    jQuery('td:nth-child(7)', tr).text('Ocurrio un error intentando solicitar el retiro');
                                }
                            },
                            async: false
                        });
                        if(_ths.procesando === false){
                            break;
                        }
                    }
                    jQuery('#dlg_solicitar_retiro').dialog('close');
                }, 400);
            }
        });
        jQuery('#btnAbotarSolicitarRetiro').on('click', function(event) {
            if(event.preventDefault) 
                event.preventDefault();
            jQuery('#dlg_solicitar_retiro').dialog('close');
        });
        jQuery('#btnCancelarSolicitarRetiro').on('click', function(event){
            if(event.preventDefault) 
                event.preventDefault();
            _ths.procesando = false;
            jQuery('#dlg_solicitar_retiro').dialog('close');
        });
    };
    this.validarSolicitudRetiro = function(){
        jQuery('#fechaRetiro', '#dlg_solicitar_retiro').css('border', '').removeAttr('title');
        jQuery('#lblfechaRetiro', '#dlg_solicitar_retiro').text('');
        let esValido = true;
        let fechaRetiro = jQuery('#fechaRetiro', '#dlg_solicitar_retiro').val();
        var fechaEsValida = /^(0[1-9]|[1-2][0-9]|3[0-1])-(0[1-9]|1[0-2])-[0-9]{4}$/.test(fechaRetiro);
        if(!fechaEsValida){
            esValido = false;
            jQuery('#fechaRetiro', '#dlg_solicitar_retiro').css('border', '1px solid red');
            jQuery('#lblfechaRetiro', '#dlg_solicitar_retiro').text('El formato de fecha no es válido.');
        }
        let fecha = fechaRetiro.split('-');
        fechaRetiro = parseInt(fecha[2] + fecha[1] + fecha[0]);
        if(_ths.fecha > fechaRetiro){
            esValido = false;
            jQuery('#fechaRetiro', '#dlg_solicitar_retiro').css('border', '1px solid red');
            jQuery('#lblfechaRetiro', '#dlg_solicitar_retiro').text('La fecha mínima para solictar el retiro no puede ser menor a ' + _ths.strFecha + '.');
        }
        return esValido;
    };
    this.mostrar_generador_etiquetas = function() {
         jQuery('.contenido2', '#dlg_generador_etiquetas').hide();
         jQuery('.contenido1', '#dlg_generador_etiquetas').show();
         jQuery('#dlg_generador_etiquetas').dialog({
            title : 'Confirmar generación de etiquetas',
            resizable: false,
            height: "auto",
            width: 400,
            modal: true,
            closeOnEscape: false,
            draggable : false
        });
    };
    this.mostrar_generador_manifiesto =  function() {
         jQuery('.contenido2', '#dlg_generador_manifiesto').hide();
         jQuery('.contenido1', '#dlg_generador_manifiesto').show();
         jQuery('#dlg_generador_manifiesto').dialog({
            title : 'Confirmar generación de manifiesto',
            resizable: false,
            height: "auto",
            width: 400,
            modal: true,
            closeOnEscape: false,
            draggable : false
        });
    };
    this.mostrar_solicitar_retiro = function() {
        jQuery('.contenido3', '#dlg_solicitar_retiro').hide();
        jQuery('.contenido2', '#dlg_solicitar_retiro').hide();
        jQuery('.contenido1', '#dlg_solicitar_retiro').show();
        jQuery('#dlg_solicitar_retiro').dialog({
            title : 'Confirmar solicitud de retiro',
            resizable: false,
            height: "auto",
            width: 400,
            modal: true,
            closeOnEscape: false,
            draggable : false
        });
    };
    this.mostrar_mensaje = function(titulo, mensaje) {
        jQuery('p','#dlg_mensaje').text(mensaje);
        jQuery('#dlg_mensaje').dialog({
            title : titulo,
            resizable: false,
            height: "auto",
            width: 400,
            modal: true,
            closeOnEscape: false,
            draggable : false,
            buttons: {
                'Aceptar': function() { jQuery(this).dialog('close');}
            }
        });
    };
    _ths.iniciar();
}
