<?php
/*
Plugin Name: Correos de Chile
Plugin URI: https://www.correos.cl/web/correos-chile-empresas/manual-woocommerce
Description: Ingresa correctamente direcciones desplegando regiones y comunas. Calcula el precio de tus despachos dependiendo del servicio, origen-destino, peso físico y volumétrico. Así podrás informar la tarifa en el momento en el que tu cliente selecciona el tipo de envío (domicilio o sucursales de CorreosChile) en el proceso de venta. Realiza la admisión de tus paquetes obteniendo el número de seguimiento, etiqueta y manifiesto para un correcto despacho de tus ventas. Realiza retiros programados o agenda un retiro para un día/hora específicos.*
Version: 1.0.17
Author: Correos de Chile
Author URI: https://www.correos.cl
*/

/* 
Historial de cambios:
1.0.05 Se agrega modo multi-tienda con plugin Dokan.
1.0.06 Se agrega la desactivación de los combos de comuna y sucursal de manera que se llenen cuando su combo de origen padre tiene información.
1.0.07 Corrección en la descarga de archivos de texto con información para la impresora Zebra, se agrega correlativo en el número de manifiesto.
1.0.08 Se agrega la opción de elegirnos como método por defecto.
       Se agrega validación para la tarificación cuando los productos no tiene peso ni dimensiones definidas.
       Se agrega validación para la tarificación por peso y volumen máximo de los productos.
       Se cambió la lista de regiones a identificadores ISO 3166-2:CL
1.0.09 Se agrega opción de re agendamiento de retiros.
1.0.10 Se agrega redondeo de volumen en el método correoschile_pedido_recibido.
1.0.11 Corrección del método correoschile_obtenerRegion.
1.0.12 Corrección del Administrador de Envíos al presionar sobre el link de la etiqueta.
1.0.13 Se agrega opción de marginar por porcentaje o valor.
1.0.14 Se agrega opción para que los envíos sean gratis a partir un valor.
1.0.15 Ajuste de horario de retiro hasta las 17:30.
1.0.16 Ajustes menores en la estructura de archivos y directorios.
       Se ha modificado para que al desactivar no elimine las tablas ni los parámetros definidos.
       Además se ha modificado el directorio de uploads a wp-content/uploads/correoschile_etiquetas y wp-content/uploads/correoschile_manifiestos.
1.0.17 Correcciones menores:
       1 - Url etiqueta desde método ajax.
       2 - Al finalizar la compra solo se registran en la tabla los envíos donde ha elegido a CorreosChile.
       3 - Se agrega filtro por estado en el admnistrador de envíos.
*/

include_once('includes/instalar.php');
include_once('includes/desinstalar.php');
include_once('includes/correoschile_shipping_method.php');
include_once("includes/api_regiones.php");
include_once("includes/api_comunas.php");
include_once("includes/api_sucursales.php");
include_once("includes/api_etiqueta.php");
include_once("includes/srv_manifiesto.php");
include_once("includes/api_retiro.php");

define('cch_path', plugin_dir_path(__FILE__));
register_activation_hook(__FILE__,'correoschile_activar');
register_deactivation_hook(__FILE__, "correoschile_desactivar");
add_action('admin_menu', 'correoschile_crear_menu');

function correoschile_activar() 
{
    correoschile_instalar_tablas();
    correoschile_instalar_opciones();
}

function correoschile_desactivar() 
{
    //Por el momento no hay necesidas de hacer nada aquí
}

function correoschile_crear_menu() 
{
    add_menu_page('Correos de Chile', 'Correos de Chile', 'manage_options', cch_path . '\\admin\\Configuracion.php', '', 'data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBzdGFuZGFsb25lPSJubyI/Pgo8IURPQ1RZUEUgc3ZnIFBVQkxJQyAiLS8vVzNDLy9EVEQgU1ZHIDIwMDEwOTA0Ly9FTiIKICJodHRwOi8vd3d3LnczLm9yZy9UUi8yMDAxL1JFQy1TVkctMjAwMTA5MDQvRFREL3N2ZzEwLmR0ZCI+CjxzdmcgdmVyc2lvbj0iMS4wIiB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciCiB3aWR0aD0iMzkwLjAwMDAwMHB0IiBoZWlnaHQ9IjMzMC4wMDAwMDBwdCIgdmlld0JveD0iMCAwIDM5MC4wMDAwMDAgMzMwLjAwMDAwMCIKIHByZXNlcnZlQXNwZWN0UmF0aW89InhNaWRZTWlkIG1lZXQiPgo8bWV0YWRhdGE+CkNyZWF0ZWQgYnkgcG90cmFjZSAxLjE2LCB3cml0dGVuIGJ5IFBldGVyIFNlbGluZ2VyIDIwMDEtMjAxOQo8L21ldGFkYXRhPgo8ZyB0cmFuc2Zvcm09InRyYW5zbGF0ZSgwLjAwMDAwMCwzMzAuMDAwMDAwKSBzY2FsZSgwLjEwMDAwMCwtMC4xMDAwMDApIgpmaWxsPSIjMDAwMDAwIiBzdHJva2U9Im5vbmUiPgo8cGF0aCBkPSJNMjM1NSAyMzczIGMtMzMgLTIgLTEyMyAtMTAgLTIwMCAtMTggLTY4OCAtNzUgLTEzNDMgLTMwOCAtMTk1NQotNjk2IC0xMzggLTg4IC0xNzcgLTExNSAtMTcwIC0xMjIgMyAtMiAxMjUgLTE3IDI3MSAtMzMgbDI2NiAtMzAgOTQgNjQgYzI1MQoxNjkgNjM1IDM3NyA5MTkgNDk3IDE4MyA3NyA1MTQgMTg2IDY4NSAyMjUgMjIyIDUwIDM4MCA3MCA2MTAgNzcgMjI3IDcgMjIyCjEzIC0yNCAzMiAtMTI0IDEwIC0zNTAgMTIgLTQ5NiA0eiIvPgo8cGF0aCBkPSJNMjc4NiAyMjkwIGMtNjQ5IC01OCAtMTM4NCAtMzQ0IC0yMDczIC04MDUgbC05NSAtNjMgNDggLTcgYzIzNCAtMzAKNTI2IC0xMTYgNzI4IC0yMTQgMjU0IC0xMjMgNTA0IC0zMjMgNjMwIC01MDIgOCAtMTMgMTcgLTIxIDIwIC0xOCAyIDIgMTggNDAKMzUgODQgNjggMTcwIDIxMyA0MDUgMzc3IDYxMCAxMTEgMTM5IDM5NCA0MjcgNTQ0IDU1NSAxMTQgOTcgMjU1IDIwOSAzNTggMjg0CjI5IDIxIDUxIDQwIDQ4IDQzIC0yNyAyOCAtNDM1IDQ5IC02MjAgMzN6Ii8+CjxwYXRoIGQ9Ik0zNDQ1IDIxOTcgYy0xNjcgLTk2IC0zOTYgLTI3OCAtNjc1IC01MzcgbC02NSAtNjAgMTQyIDk0IGMxNjEgMTA3CjM1MCAyMDYgNTE4IDI3MiAxMjcgNDkgMzQ2IDEwOSA0NDMgMTIwIDM1IDQgNjAgMTAgNTUgMTUgLTI0IDIzIC0zMjAgMTE5Ci0zNjcgMTE5IC02IDAgLTI5IC0xMSAtNTEgLTIzeiIvPgo8cGF0aCBkPSJNNTAwIDEzMTIgYy05MCAtNTcgLTUwNyAtNDA4IC00OTcgLTQxOCAyIC0yIDUxIDcgMTA5IDIxIDQ3MCAxMTEKOTIxIDEzNiAxMjU4IDY5IDIzNCAtNDYgNDUxIC0xNDQgNTgxIC0yNjEgNzcgLTY5IDI0IDQgLTcxIDk4IC0yMzcgMjM1IC02MzcKNDEwIC0xMTEyIDQ4OCAtMjIwIDM2IC0yMTcgMzYgLTI2OCAzeiIvPgo8L2c+Cjwvc3ZnPgo=');
    add_submenu_page(cch_path . '/admin/Configuracion.php', 'Administrador de Envíos', 'Administrar Envíos', 'manage_options', cch_path . '\\admin\\AdministradorEnvios.php');
}

if (in_array( 'correos_chile/correos_chile.php', apply_filters('active_plugins',get_option('active_plugins'))) &&
    in_array( 'woocommerce/woocommerce.php', apply_filters('active_plugins',get_option('active_plugins'))))
{

    $plugin = plugin_basename(__FILE__); 
    add_filter("plugin_action_links_$plugin", 'correoschile_settings_link' );
    
    add_filter('woocommerce_states', 'correoschile_custom_woocommerce_states');
    add_filter('woocommerce_shipping_methods','correoschile_add_shipping_method');
    add_filter('woocommerce_checkout_fields', 'correoschile_order_checkout_fields' );	
    add_filter('woocommerce_default_address_fields', 'correoschile_default_address_fields' );
    add_filter('woocommerce_shipping_chosen_method', 'correoschile_default_shipping_method', 10, 2);
    add_filter('woocommerce_cart_shipping_method_full_label', 'correoschile_cart_shipping_method_full_label', 10, 2);

    add_action('woocommerce_shipping_init','correoschile_iniciar_shipping_method');
    add_action('admin_post_correoschile_configuracion', 'correoschile_configuracion');
    add_action('wp_enqueue_scripts','correoschile_enqueue_scripts');
    add_action('wp_ajax_correoschile_regiones', 'correoschile_ajax_regiones');
    add_action('wp_ajax_nopriv_correoschile_regiones', 'correoschile_ajax_regiones');
    add_action('wp_ajax_correoschile_comunas', 'correoschile_ajax_comunas');
    add_action('wp_ajax_nopriv_correoschile_comunas', 'correoschile_ajax_comunas');
    add_action('wp_ajax_correoschile_sucursales', 'correoschile_ajax_sucursales');
    add_action('wp_ajax_nopriv_correoschile_sucursales', 'correoschile_ajax_sucursales');
    add_action('wp_ajax_correoschile_etiquetas', 'correoschile_ajax_generar_etiqueta');
    add_action('wp_ajax_correoschile_manifiesto', 'correoschile_ajax_generar_manifiesto');
    add_action('wp_ajax_correoschile_retiro', 'correoschile_ajax_registrar_retiro');
}

function correoschile_default_shipping_method($method, $available_methods){
    $default = get_option('correoschile_ordenarCamposCheckout', '');
    if($default === 'S')
    {
        $default_method = 'correoschile_shipping_method';
        if( array_key_exists($method, $available_methods))
        {
            return $default_method;
        }
    }
    return $method;
}

function correoschile_cart_shipping_method_full_label($label, $method) 
{
   if( $method->method_id == "correoschile_shipping_method" ) 
   {
       $label =  '<img style="margin: max-width:130px;" src="data:image/png;base64,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" alt="CorreosChile"/>' . $label;
   }
   return $label; 
}

function correoschile_settings_link($links) 
{ 
  $settings_link = '<a href="admin.php?page=correos_chile%2Fadmin%2FConfiguracion.php">Configuración</a>'; 
  array_unshift($links, $settings_link); 
  return $links; 
}

function correoschile_configuracion()
{
    if ($_SERVER['REQUEST_METHOD'] === 'POST')
    {
        $nombre_tienda = filter_input(INPUT_POST, 'correoschile_nombre_tienda');
        $rut = filter_input(INPUT_POST, 'correoschile_rut');
        $direccion = filter_input(INPUT_POST, 'correoschile_direccion');
        $comuna = filter_input(INPUT_POST, 'correoschile_comuna');
        $codigoPostal = filter_input(INPUT_POST, 'correoschile_codigoPostal');
        $nombre = filter_input(INPUT_POST, 'correoschile_nombre');
        $telefono = filter_input(INPUT_POST, 'correoschile_telefono');
        $codigoSAP = filter_input(INPUT_POST, 'correoschile_codigoSAP');
    
        $ambiente = filter_input(INPUT_POST, 'correoschile_ambiente_api');
        $usuario = filter_input(INPUT_POST, 'correoschile_usuario_api');
        $contrasena = filter_input(INPUT_POST, 'correoschile_contrasena_api');
        $formatoEtiqueta = filter_input(INPUT_POST, 'correoschile_formato_etiqueta');
    
        $wsRegiones = filter_input(INPUT_POST, 'correoschile_ws_region');
        $wsComunas = filter_input(INPUT_POST, 'correoschile_ws_comuna');
        $wsSucursales = filter_input(INPUT_POST, 'correoschile_ws_sucursal');
        $wsNormalizacion = filter_input(INPUT_POST, 'correoschile_ws_normalizacion');
        $wsTarificacion = filter_input(INPUT_POST, 'correoschile_ws_tarificacion');
        $wsRetiro = filter_input(INPUT_POST, 'correoschile_ws_retiro');
        $wsTrazabilidad = filter_input(INPUT_POST, 'correoschile_ws_trazabilidad');
        $wsEtiquetas = filter_input(INPUT_POST, 'correoschile_ws_etiquetas');
    
        $default = filter_input(INPUT_POST, 'correoschile_default');
        $cargarRegiones = filter_input(INPUT_POST, 'correoschile_cargarRegiones');
        $tarificar = filter_input(INPUT_POST, 'correoschile_tarificar');
        $ordenarCamposCheckout = filter_input(INPUT_POST, 'correoschile_ordenarCamposCheckout');
        $calcularPorTienda = filter_input(INPUT_POST, 'correoschile_calcularPorTienda');
        $ocultarCompanyField = filter_input(INPUT_POST, 'correoschile_ocultarCompanyField');
       
        $marginar = filter_input(INPUT_POST, 'correoschile_marginar');
        $marginar_valor = filter_input(INPUT_POST, 'correoschile_marginar_valor');
        $no_tarificar = filter_input(INPUT_POST, 'correoschile_no_tarificar');

        if(get_option('correoschile_nombre_tienda') === false) { add_option('correoschile_nombre_tienda', 255,'','yes'); }
        update_option('correoschile_nombre_tienda', $nombre_tienda , true);
        if(get_option('correoschile_rut') === false) { add_option('correoschile_rut', 255,'','yes'); }
        update_option('correoschile_rut', $rut, true);
        if(get_option('correoschile_direccion') === false) { add_option('correoschile_direccion', 255,'','yes'); }
        update_option('correoschile_direccion', $direccion, true);
        if(get_option('correoschile_comuna') === false) { add_option('correoschile_comuna', 255,'','yes'); }
        update_option('correoschile_comuna', $comuna, true);
        if(get_option('correoschile_codigoPostal') === false) { add_option('correoschile_codigoPostal', 255,'','yes'); }
        update_option('correoschile_codigoPostal', $codigoPostal, true);
        if(get_option('correoschile_nombre') === false) { add_option('correoschile_nombre', 255,'','yes'); }
        update_option('correoschile_nombre', $nombre, true);
        if(get_option('correoschile_telefono') === false) { add_option('correoschile_telefono', 255,'','yes'); }
        update_option('correoschile_telefono', $telefono, true);
        if(get_option('correoschile_codigoSAP') === false) { add_option('correoschile_codigoSAP', 255,'','yes'); }
        update_option('correoschile_codigoSAP', $codigoSAP,'yes');
    
        if(get_option('correoschile_ambiente_api') === false) { add_option('correoschile_ambiente_api', 255,'','yes'); }
        update_option('correoschile_ambiente_api', $ambiente, true); //CERTIFICACION | PRODUCCION
        if(get_option('correoschile_usuario_api') === false) { add_option('correoschile_usuario_api', 255,'','yes'); }
        update_option('correoschile_usuario_api', $usuario, true);
        if(get_option('correoschile_contrasena_api') === false) { add_option('correoschile_contrasena_api', 255,'','yes'); }
        update_option('correoschile_contrasena_api', $contrasena, true);
        if(get_option('correoschile_formato_etiqueta') === false) { add_option('correoschile_formato_etiqueta', 255,'','yes'); }
        update_option('correoschile_formato_etiqueta', $formatoEtiqueta, true); //PDF | PDFS | ZPL
    
        if(get_option('correoschile_ws_region') === false) { add_option('correoschile_ws_region', 255,'','yes'); }
        update_option('correoschile_ws_region', $wsRegiones, true);
        if(get_option('correoschile_ws_comuna') === false) { add_option('correoschile_ws_comuna', 255,'','yes'); }
        update_option('correoschile_ws_comuna', $wsComunas, true);
        if(get_option('correoschile_ws_sucursal') === false) { add_option('correoschile_ws_sucursal', 255,'','yes'); }
        update_option('correoschile_ws_sucursal', $wsSucursales, true);
        if(get_option('correoschile_ws_normalizacion') === false) { add_option('correoschile_ws_normalizacion', 255,'','yes'); }
        update_option('correoschile_ws_normalizacion', $wsNormalizacion, true);
        if(get_option('correoschile_ws_tarificacion') === false) { add_option('correoschile_ws_tarificacion', 255,'','yes'); }
        update_option('correoschile_ws_tarificacion', $wsTarificacion, true);
        if(get_option('correoschile_ws_retiro') === false) { add_option('correoschile_ws_retiro', 255,'','yes'); }
        update_option('correoschile_ws_retiro', $wsRetiro, true);
        if(get_option('correoschile_ws_trazabilidad') === false) { add_option('correoschile_ws_trazabilidad', 255,'','yes'); }
        update_option('correoschile_ws_trazabilidad', $wsTrazabilidad, true);
        if(get_option('correoschile_ws_etiquetas') === false) { add_option('correoschile_ws_etiquetas', 255,'','yes'); }
        update_option('correoschile_ws_etiquetas', $wsEtiquetas, true);

        if(get_option('correoschile_default') === false) { add_option('correoschile_default', 255,'','yes'); }
        update_option('correoschile_default', !isset($default) ? 'N' : 'S', true);
        if(get_option('correoschile_cargarRegiones') === false) { add_option('correoschile_cargarRegiones', 255,'','yes'); }
        update_option('correoschile_cargarRegiones', !isset($cargarRegiones) ? 'N' : 'S', true);        
        if(get_option('correoschile_tarificar') === false) { add_option('correoschile_tarificar', 255,'','yes'); }
        update_option('correoschile_tarificar', !isset($tarificar) ? 'N' : 'S', true);
        if(get_option('correoschile_ordenarCamposCheckout') === false) { add_option('correoschile_ordenarCamposCheckout', 255,'','yes'); }
        update_option('correoschile_ordenarCamposCheckout', !isset($ordenarCamposCheckout) ? 'N' : 'S', true);
        if(get_option('correoschile_calcularPorTienda') === false) { add_option('correoschile_calcularPorTienda', 255,'','yes'); }
        update_option('correoschile_calcularPorTienda', !isset($calcularPorTienda) ? 'N' : 'S', true);
        if(get_option('correoschile_ocultarCompanyField') === false) { add_option('correoschile_ocultarCompanyField', 255,'','yes'); }
        update_option('correoschile_ocultarCompanyField', !isset($ocultarCompanyField) ? 'N' : 'S', true);
        if(get_option('correoschile_marginar') === false) { add_option('correoschile_marginar', 255,'','yes'); }
        update_option('correoschile_marginar', $marginar, true);
        if(get_option('correoschile_marginar_valor') === false) { add_option('correoschile_marginar_valor', 255,'','yes'); }
        update_option('correoschile_marginar_valor', $marginar_valor, true);
        if(get_option('correoschile_no_tarificar') === false) { add_option('correoschile_no_tarificar', 255,'','yes'); }
        update_option('correoschile_no_tarificar', $no_tarificar, true);
        
        $url = get_admin_url() . 'admin.php?page=correos_chile%2Fadmin%2FConfiguracion.php&s=1';
        wp_redirect($url);
        exit();
    }
}

function correoschile_custom_woocommerce_states($states) 
{
    $regiones = get_option('correoschile_cargarRegiones', '');
    if($regiones === 'S')
    {
        $regiones = array();
        $regiones['CL-AP'] = 'Región de Arica y Parinacota';
        $regiones['CL-TA'] = 'Región de Tarapacá';
        $regiones['CL-AN'] = 'Región de Antofagasta';
        $regiones['CL-AT'] = 'Región de Atacama';
        $regiones['CL-CO'] = 'Región de Coquimbo';
        $regiones['CL-VS'] = 'Región de Valparaíso';
        $regiones['CL-RM'] = 'Región de Metropolitana de Santiago';
        $regiones['CL-LI'] = 'Región de Libertador General Bernardo O`Higgins';
        $regiones['CL-ML'] = 'Región de Maule';
        $regiones['CL-NB'] = 'Región de Ñuble';
        $regiones['CL-BI'] = 'Región de Biobío';
        $regiones['CL-AR'] = 'Región de Araucanía';
        $regiones['CL-LR'] = 'Región de Los Ríos';
        $regiones['CL-LL'] = 'Región de Los Lagos';
        $regiones['CL-AI'] = 'Región de Aysén del General Carlos Ibáñez del Campo';
        $regiones['CL-MA'] = 'Región de Magallanes y la Antártica Chilena';
        $states['CL'] = $regiones;
        /* FORMA ORIGINAL DE OBTENER LAS REGIONES 
        if(is_cart() || is_checkout()){
            try {
                $regiones = correoschile_regiones();
                $array_regiones = array();
                foreach($regiones as $region){
                    $array_regiones['CL-' . $region->Identificador] = $region->Nombre;
                }
                $states['CL'] = $array_regiones;
            }
            catch(Exception $e)
            {
                //nada
            }
        }
        */
    }
    return $states;
}

function correoschile_enqueue_scripts()
{
    $enable_shipping_calc = get_option('woocommerce_enable_shipping_calc');
    $shipping_methods = WC()->shipping->load_shipping_methods();
    if($shipping_methods['correoschile_shipping_method']->enabled === 'yes')
    {
        if(is_cart() && $enable_shipping_calc === 'yes') 
        {
            wp_enqueue_script('correoschile_shipping_calculator', plugin_dir_url(__FILE__) . 'public/js/correoschile_cart.js', ['jquery', 'woocommerce', 'jquery-blockui', 'select2'], '', true );
            correoschile_localize_script();
        }
        if(is_checkout()) 
        {
            wp_enqueue_script('correoschile_shipping_calculator', plugin_dir_url(__FILE__) . 'public/js/correoschile_checkout.js', ['jquery', 'woocommerce', 'jquery-blockui', 'select2'], '', true );
            correoschile_localize_script();
        }
    }
}

function correoschile_localize_script()
{
    wp_localize_script('correoschile_shipping_calculator', 'correoschile_var', 
        ['url' => admin_url('admin-ajax.php'), 
         'nonce_comunas' => wp_create_nonce('nonce_comunas'),
         'nonce_sucursales' => wp_create_nonce('nonce_sucursales')
    ]);
}

function correoschile_order_checkout_fields( $fields ) 
{
    $ordernar = get_option('correoschile_ordenarCamposCheckout', '');
    if($ordernar === 'S')
    {
        $fields['billing']['billing_first_name']['priority'] = 10;
        $fields['billing']['billing_last_name']['priority'] = 20;
        $fields['billing']['billing_company']['priority'] = 30;
        $fields['billing']['billing_country']['priority'] = 40;
        $fields['billing']['billing_state']['priority'] = 50;
        $fields['billing']['billing_city']['priority'] = 60;
        $fields['billing']['billing_address_1']['priority'] = 70;
        $fields['billing']['billing_address_2']['priority'] = 80;
        $fields['billing']['billing_postcode']['priority'] = 90;
        $fields['billing']['billing_email']['priority'] = 100;
        $fields['billing']['billing_phone']['priority'] = 110;
    }
    return $fields;		
}

function correoschile_default_address_fields( $fields ) 
{
    $ordernar = get_option('correoschile_ordenarCamposCheckout', '');
    if($ordernar === 'S')
    {
        $fields['first_name']['priority'] = 10;
        $fields['last_name']['priority'] = 20;
        $fields['company']['priority'] = 30;
        $fields['country']['label'] = 'País';
        $fields['country']['priority'] = 40;
        $fields['state']['label'] = 'Región';
        $fields['state']['priority'] = 50;
        $fields['city']['label'] = 'Comuna';
        $fields['city']['priority'] = 60;
        $fields['address_1']['label'] = 'Dirección o Sucursal';
        $fields['address_1']['priority'] = 70;
        $fields['address_2']['priority'] = 80;
        $fields['postcode']['priority'] = 90;
        $fields['email']['priority'] = 100;
        $fields['phone']['priority'] = 110;
    }
    return $fields;
}
