<?php

require_once('tbl_comunas.php');

function correoschile_ajax_comunas() {
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
        try {
            $region = filter_input(INPUT_POST, 'region');
            $comunas = correoschile_comunasPorRegion($region);
            header('http/1.1 200 OK');
            header('Content-Type: application/json; charset=UTF8');
            echo json_encode($comunas);
            exit();
        } catch(Exception $e) {
            header('http/1.1 500 Internal Server Error');
            header('Content-Type: application/json; charset=UTF8');
            die(json_encode(array('message' => $e->getMessage())));
        }
    } else {
        header('http/1.1 500 Internal Server Error');
        header('Content-Type: application/json; charset=UTF8');
        die(json_encode(array('message' => 'Este método solo puede ser invocado con POST')));
    }
}

function correoschile_comunas() {
    $wsdl = trim(get_option('correoschile_ws_comuna', ''));
    if($wsdl !== '' && substr_compare(strtolower($wsdl), '?wsdl', -strlen('?wsdl')) < 0)
        $wsdl .= '?wsdl';
    $client = new SoapClient($wsdl, array('trace' => 1, 'exception' => 0));
    try {
        $result = $client->__soapCall('listarTodasLasComunas', array(
            'listarTodasLasComunas' => array(
                'usuario' => trim(get_option('correoschile_usuario_api')),
                'contrasena' => trim(get_option('correoschile_contrasena_api'))
            )), null, null);
        return $result->listarTodasLasComunasResult->ComunaTO;
    } catch (SoapFault $e) {
        throw new Exception($e->getMessage(), 0, $e);
    } catch (Exception $e) {
        throw new Exception('Ocurio un errror intentando obtener las comunas.', 0, $e);
    }
    return wp_cache_get('correoschile_comunas');
}

function correoschile_obtenerComuna($codigoRegion, $codigoComuna) {
    try {
        $comunaObtenida = null;
        $comunas = correoschile_comunasPorRegion($codigoRegion);
        if(is_array($comunas)){
            foreach($comunas as $comuna){
                if($comuna->Iata !== $codigoComuna && $comuna->NombreComuna !== $codigoComuna)
                    continue;
                $comunaObtenida = $comuna;
                break;
            }
        } else {
            if($comunas->Iata === $codigoComuna || $comunas->NombreComuna === $codigoComuna)
                $comunaObtenida = $comunas;
        }
        return $comunaObtenida;
    } catch(Exception $e) {
        return null;
    }
}

function correoschile_comunasPorRegion($codigoRegion) {
    //AJUSTES ISO 3166-2:CL
    switch($codigoRegion){
        case 'CL-AP': $codigoRegion = '646'; break; //'Arica y Parinacota'
        case 'CL-TA': $codigoRegion = '202'; break; //'Tarapacá'
        case 'CL-AN': $codigoRegion = '203'; break; //'Antofagasta'
        case 'CL-AT': $codigoRegion = '204'; break; //'Atacama'
        case 'CL-CO': $codigoRegion = '205'; break; //'Coquimbo'
        case 'CL-VS': $codigoRegion = '206'; break; //'Valparaíso'
        case 'CL-RM': $codigoRegion = '214'; break; //'Metropolitana de Santiago'
        case 'CL-LI': $codigoRegion = '207'; break; //'Libertador General Bernardo O`Higgins'
        case 'CL-ML': $codigoRegion = '208'; break; //'Maule'
        case 'CL-NB': $codigoRegion = '8783'; break; //'Ñuble'
        case 'CL-BI': $codigoRegion = '209'; break; //'Biobío'
        case 'CL-AR': $codigoRegion = '210'; break; //'Araucanía'
        case 'CL-LR': $codigoRegion = '659'; break; //'Los Ríos'
        case 'CL-LL': $codigoRegion = '211'; break; //'Los Lagos'
        case 'CL-AI': $codigoRegion = '212'; break; //'Aysén del General Carlos Ibáñez del Campo'
        case 'CL-MA': $codigoRegion = '213'; break; //'Magallanes y la Antártica Chilena'
    }
    
/*    
    $total = correoschile_totalComunas();
    if($total === 0){
        correoschile_agregar_comunas();
    }
*/

    $wsdl = trim(get_option('correoschile_ws_comuna', ''));
    if($wsdl !== '' && substr_compare(strtolower($wsdl), '?wsdl', -strlen('?wsdl')) < 0) {
        $wsdl .= '?wsdl';
    }
    try {
        $client = new SoapClient($wsdl, array('trace' => 1, 'exception' => 0));
        $result = $client->__soapCall('listarComunasSegunRegion', array(
            'listarComunasSegunRegion' => array(
                'usuario' => trim(get_option('correoschile_usuario_api')),
                'contrasena' => trim(get_option('correoschile_contrasena_api')),
                'codigoRegion' => $codigoRegion
            )), null, null);
        return $result->listarComunasSegunRegionResult->ComunaTO;
    } catch (SoapFault $e) {
        throw new Exception($e->getMessage(), 0, $e);
    }
    catch (Exception $e) {
        throw new Exception('Ocurio un errror intentando obtener las comunas según región.', 0, $e);
    }
}

