<?php

function correoschile_ajax_regiones() 
{
    if ($_SERVER['REQUEST_METHOD'] === 'POST') 
    {
        try 
        {
            if(isset($correoschile_regiones)) {
                $regiones = $correoschile_regiones;
            } else {
                $regiones = correoschile_regiones();
                $correoschile_regiones = $regiones;
            }
            header('http/1.1 200 OK');
            header('Content-Type: application/json; charset=UTF8');
            echo json_encode($regiones);
            exit();
        } 
        catch( Exception $e)
        {
            header('http/1.1 500 Internal Server Error');
            header('Content-Type: application/json; charset=UTF8');
            die(json_encode(array('message' => $e->getMessage())));
        }
    }
    else 
    {
        header('http/1.1 500 Internal Server Error');
        header('Content-Type: application/json; charset=UTF8');
        die(json_encode(array('message' => 'Este método solo puede ser invocado con POST')));
    }
}

function correoschile_obtenerRegion($codigoRegion)
{
    //AJUSTES ISO 3166-2:CL
    switch($codigoRegion){
        case 'CL-AP': $codigoRegion = '646'; break; //'Arica y Parinacota'
        case 'CL-TA': $codigoRegion = '202'; break; //'Tarapacá'
        case 'CL-AN': $codigoRegion = '203'; break; //'Antofagasta'
        case 'CL-AT': $codigoRegion = '204'; break; //'Atacama'
        case 'CL-CO': $codigoRegion = '205'; break; //'Coquimbo'
        case 'CL-VS': $codigoRegion = '206'; break; //'Valparaíso'
        case 'CL-RM': $codigoRegion = '214'; break; //'Metropolitana de Santiago'
        case 'CL-LI': $codigoRegion = '207'; break; //'Libertador General Bernardo O`Higgins'
        case 'CL-ML': $codigoRegion = '208'; break; //'Maule'
        case 'CL-NB': $codigoRegion = '8783'; break; //'Ñuble'
        case 'CL-BI': $codigoRegion = '209'; break; //'Biobío'
        case 'CL-AR': $codigoRegion = '210'; break; //'Araucanía'
        case 'CL-LR': $codigoRegion = '659'; break; //'Los Ríos'
        case 'CL-LL': $codigoRegion = '211'; break; //'Los Lagos'
        case 'CL-AI': $codigoRegion = '212'; break; //'Aysén del General Carlos Ibáñez del Campo'
        case 'CL-MA': $codigoRegion = '213'; break; //'Magallanes y la Antártica Chilena'
    }
    
    try
    {
        $regiones = correoschile_regiones();
        $regionObtenida = null;
        foreach($regiones as $region){
            if($region->Identificador !== $codigoRegion)
                continue;
            $regionObtenida = $region;
            break;
        }
        return $regionObtenida;
    }
    catch(Exception $e)
    {
        return null;
    }
}

function correoschile_regiones()
{
    $wsdl = trim(get_option('correoschile_ws_region',''));
    if($wsdl !== '' && substr_compare(strtolower($wsdl), '?wsdl', -strlen('?wsdl')) < 0){
        $wsdl .= '?wsdl';
    }
    try
    {
        $client = new SoapClient($wsdl, array('trace' => 1, 'exception' => 0));
        $result = $client->__soapCall('listarTodasLasRegiones', array(
            'listarTodasLasRegiones' => array(
                'usuario' => trim(get_option('correoschile_usuario_api')),
                'contrasena' => trim(get_option('correoschile_contrasena_api'))
            )), null, null);
        return $result->listarTodasLasRegionesResult->RegionTO;
    }
    catch (Exception $e) {
        throw new Exception('Ocurio un errror intentando obtener las regiones.', 0, $e);
    }
}