<?php

function correoschile_coberturaPorProducto($codigoServicio, $comunaRemitente, $comunaDestinatario, $kilos, $volumen)
{
    $wsdl = trim(get_option('correoschile_ws_tarificacion', ''));
    if($wsdl !== '' && substr_compare(strtolower($wsdl), '?wsdl', -strlen('?wsdl')) < 0){
        $wsdl .= '?wsdl';
    }
    try
    {
        $client = new SoapClient($wsdl, array('trace' => 1, 'exception' => 0));
        $result = $client->__soapCall('consultaCoberturaPorProducto', array(
            'consultaCoberturaPorProducto' => array(
                'usuario' => trim(get_option('correoschile_usuario_api')), 
                'contrasena' => trim(get_option('correoschile_contrasena_api')),
                'consultaCobertura' => array(
                    'CodigoServicio' => $codigoServicio, 
                    'ComunaDestino' => $comunaDestinatario, 
                    'ComunaRemitente' => $comunaRemitente, 
                    'Kilos' => $kilos, 
                    'Volumen' => $volumen,
                    'NumeroTotalPieza' => '1', 
                    'PaisDestinatario' => '056', 
                    'PaisRemitente' => '056', 
                    'TipoPortes' => 'P'
                )
            )), null, null);
        return $result->consultaCoberturaPorProductoResult;
    }
    catch (SoapFault $e) {
        throw new Exception($e->getMessage(), 0, $e);
    }
    catch (Exception $e) {
        throw new Exception('Ocurio un errror intentando obtener la tarificación.', 0, $e);
    }
}