<?php

require_once('api_comunas.php');

function correoschile_crear_tabla_comunas(){
    global $wpdb;
    $table = $wpdb->prefix . 'correoschile_comunas';
    if($wpdb->get_var("show tables like '$table'") != $table) { 
	$charset_collate = $wpdb->get_charset_collate();
        $sql = "CREATE TABLE {$table} (
                Region VARCHAR(10) NOT NULL,
                Iata VARCHAR(3) NOT NULL,
                NombreComuna VARCHAR(255) NULL,
                Auxiliar1 VARCHAR(255) NULL,
                Auxiliar2 VARCHAR(255) NULL,
                ISO3166 VARCHAR(5) NULL,
                PRIMARY KEY (Iata)
        ) $charset_collate;";
        require_once( ABSPATH . 'wp-admin/includes/upgrade.php' );
        dbDelta( $sql );
    }
}

function correoschile_eliminar_tabla_Comunas() {
    global $wpdb;
    $table_name = $wpdb-> prefix . 'correoschile_envios';
    $wpdb->query("DROP TABLE IF EXISTS $table_name");
}

function correoschile_agregar_comunas() {
    global $wpdb;
    $table = $wpdb->prefix . 'correoschile_comunas';
    try {
        $comunas = correoschile_comunas();
        foreach($comunas as $comuna){
            //AJUSTES ISO 3166-2:CL
            $iso3166 = '';
            switch($codigoRegion){
                case '646': $iso3166 = 'CL-AP'; break; //'Arica y Parinacota'
                case '202': $iso3166 = 'CL-TA'; break; //'Tarapacá'
                case '203': $iso3166 = 'CL-AN'; break; //'Antofagasta'
                case '204': $iso3166 = 'CL-AT'; break; //'Atacama'
                case '205': $iso3166 = 'CL-CO'; break; //'Coquimbo'
                case '206': $iso3166 = 'CL-VS'; break; //'Valparaíso'
                case '214': $iso3166 = 'CL-RM'; break; //'Metropolitana de Santiago'
                case '207': $iso3166 = 'CL-LI'; break; //'Libertador General Bernardo O`Higgins'
                case '208': $iso3166 = 'CL-ML'; break; //'Maule'
                case '8783': $iso3166 = 'CL-NB'; break; //'Ñuble'
                case '209': $iso3166 = 'CL-BI'; break; //'Biobío'
                case '210': $iso3166 = 'CL-AR'; break; //'Araucanía'
                case '659': $iso3166 = 'CL-LR'; break; //'Los Ríos'
                case '211': $iso3166 = 'CL-LL'; break; //'Los Lagos'
                case '212': $iso3166 = 'CL-AI'; break; //'Aysén del General Carlos Ibáñez del Campo'
                case '213': $iso3166 = 'CL-MA'; break; //'Magallanes y la Antártica Chilena'
            }
            
            $wpdb->insert($table, array(
                'Region' => $comuna->Region,
                'Iata' => $comuna->Iata,
                'NombreComuna' => $comuna->NombreComuna,
                'Auxiliar1' => $comuna->Auxiliar1,
                'Auxiliar2' => $comuna->Auxiliar2,
                'ISO3166' => $iso3166
            ));
        }
    } catch (Exception $ex) {
        throw new Exception('Ocurio un errror intentando cargar la tabla de comunas.', 0, $e);
    }
}

function correoschile_eliminar_comunas($order_id) {
    global $wpdb;
    $table = $wpdb->prefix . 'correoschile_comunas';
    $wpdb->delete($table);
}

/*
function correoschile_obtenerComunaPorNombre($nombre) {
    $comunas = correoschile_buscarComunas('','', $nombre);
    if(count($comunas) === 1)
        return $comunas[0];
    return null;
}
*/

function correoschile_totalComunas() {
    global $wpdb;
    $total = $wpdb->get_var('SELECT COUNT(*) FROM ' . $wpdb->prefix . 'correoschile_comunas');
    return $total;
}

function correoschile_buscarComunas($region = '', $iata = '', $nombreComuna = '') {
    global $wpdb;
    $idRegion = strval($idRegion);
    $idComuna = strval($idComuna);
    $nombre = strval($nombre);
    
    $table = $wpdb->prefix . 'correoschile_comunas';
    $sql = "SELECT Region"
               . ",Iata"
               . ",NombreComuna"
               . ",Auxiliar1"
               . ",Auxiliar2"
               . ",ISO3166"
        . " FROM $table ";
    $where = '';
    if($region !== '') $where .= ($where === '' ? ' WHERE ' : ' AND ') . " Region = '" . $region . "' ";
    if($iata !== '') { $where .= ($where === '' ? ' WHERE ' : ' AND ') . " Iata = '" . $iata . "' "; }
    if($nombreComuna !== '') { $where .= ($where === '' ? ' WHERE ' : ' AND ') . " NombreComuna = '" . $nombreComuna . "' "; }
         
    $comunas = $wpdb->get_results($sql . $where);
    return $comunas;
}

