var correoschile_checkout = function(prms) {
    _ths = this;
    this.iniciado = false;
    this.cargando = false;
    this.billing_address_1 = '';
    this.billing_address_2 = '';
    this.prms = prms;
    this.iniciar = function(){
        _ths.cargando = true;
        _ths.establecerCambiosAlIniciarCheckOut();
        _ths.establecerCambiosAlActualizarCheckOut();
    };
    this.establecerCambiosAlIniciarCheckOut = function() {
        jQuery(document).on('init_checkout', function() {
            jQuery('#customer_details').block({ message: null, overlayCSS: { backgroundColor: '#fff', opacity: 0.6, cursor: 'wait' } });
            _ths.realizarTransformaciones();
            let ok = false;
            let shipping_methods = jQuery('.woocommerce-shipping-methods');
            for(let i = 0; i < shipping_methods.length; i++){
                if(jQuery('li', shipping_methods[i]).length === 1 && jQuery('li input', shipping_methods[i]).val() === 'correoschile_shipping_method'){
                    ok = true;
                    break;
                }
                if (jQuery('li input:checked', shipping_methods[i]).val() === 'correoschile_shipping_method'){
                    ok = true;
                    break;
                }
            }
            if(!ok) {
                shipping_methods = jQuery('.shipping_method');
                if (shipping_methods.length > 0) {
                    if(shipping_methods.length === 1 && jQuery(shipping_methods).val() === 'correoschile_shipping_method'){
                        ok = true;
                    }
                    if (jQuery('.shipping_method:checked').val() === 'correoschile_shipping_method'){
                        ok = true;
                    }
                }
            }
            if(ok){
                _ths.restablecerValores();
            }
            jQuery('#customer_details').unblock();
        });
    };
    this.establecerCambiosAlActualizarCheckOut = function() {
        jQuery(document).on('updated_checkout', function() {
            if(!_ths.iniciado) {
                _ths.iniciado = true;
                return;
            }
            let ok = false;
            var shipping_methods = jQuery('.woocommerce-shipping-methods');
            for(let i = 0; i < shipping_methods.length; i++){
                if(jQuery('li', shipping_methods[i]).length === 1 && jQuery('li input', shipping_methods[i]).val() === 'correoschile_shipping_method'){
                    ok = true;
                    break;
                }
                if (jQuery('li input:checked', shipping_methods[i]).val() === 'correoschile_shipping_method'){
                    ok = true;
                    break;
                }
            }
            if(!ok) {
                var shipping_methods = jQuery('.shipping_method');
                if (shipping_methods.length > 0) {
                    if(shipping_methods.length === 1 && jQuery(shipping_methods).val() === 'correoschile_shipping_method'){
                        ok = true;
                    }
                    if (jQuery('.shipping_method:checked').val() === 'correoschile_shipping_method'){
                        ok = true;
                    }
                }
            }
            _ths.establecerValoresPorDefecto();
            _ths.establecerVisualizacionDeControles('billing', ok);
            if(jQuery('#ultimo_cambio').val() === 'billing_tipoDespacho'){
                jQuery('#ultimo_cambio').val('');
            }
            if(jQuery('#ultimo_cambio').val() === 'billing_country'){
                jQuery('#ultimo_cambio').val('');
            }
            if(jQuery('#ultimo_cambio').val() === 'billing_state'){
                jQuery('#ultimo_cambio').val('');
                _ths.cargarComunas('billing', jQuery('#billing_state').val(), function() { });
            }
            if(jQuery('#ultimo_cambio').val() === 'billing_comuna'){
                jQuery('#ultimo_cambio').val('');
                let comuna = jQuery('#billing_comuna option:selected').text();
                jQuery('#billing_city').val(comuna);
                jQuery('#billing_address_1').val('');
                jQuery('#billing_address_2').val('');
                _ths.cargarSucursales('billing', jQuery('#billing_comuna').val(), function() { });
            }
            
            _ths.establecerVisualizacionDeControles('shipping', ok);
            if(jQuery('#ultimo_cambio').val() === 'shipping_tipoDespacho'){
                jQuery('#ultimo_cambio').val('');
            }
            if(jQuery('#ultimo_cambio').val() === 'shipping_country'){
                jQuery('#ultimo_cambio').val('');
            }
            if(jQuery('#ultimo_cambio').val() === 'shipping_state'){
                jQuery('#ultimo_cambio').val('');
                _ths.cargarComunas('shipping', jQuery('#shipping_state').val(), function() { });
            }
            if(jQuery('#ultimo_cambio').val() === 'shipping_comuna'){
                jQuery('#ultimo_cambio').val('');
                let comuna = jQuery('#shipping_comuna option:selected').text();
                jQuery('#shipping_city').val(comuna);
                jQuery('#shipping_address_1').val('');
                jQuery('#shipping_address_2').val('');
                _ths.cargarSucursales('shipping', jQuery('#shipping_comuna').val(), function() { });
            }
        });
    };
    this.realizarTransformaciones = function(){
        if(jQuery('#billing_tipoDespacho_field').length === 0){
            jQuery('#billing_country_field').before('<input type="hidden" name="shipping_calculator" id="shipping_calculator" value="finalizar_compra"/>');
            jQuery('#billing_country_field').before('<input type="hidden" name="ultimo_cambio" id="ultimo_cambio" value=""/>');
            jQuery('#billing_country_field').after('<p id="billing_tipoDespacho_field" class="form-row form-row-wide" style="display:none;"></p>');
            jQuery('#billing_tipoDespacho_field').append('<ul style="list-style: none; margin:0;"><li><input type="radio" name="billing_tipoDespacho" id="billing_ped" value="24"><label style="display:inline;" for="billing_ped">Despacho a Domicilio</label></li><li><input type="radio" name="billing_tipoDespacho" id="billing_pes" value="07"><label style="display:inline;" for="billing_pes">Despacho a Sucursal</label></li></ul>');
            jQuery('#billing_city_field').append('<div id="billing_comuna_container" style="display:none;"><select id="billing_comuna" name="billing_comuna" style="width: 100%"></select><span style="color:red;" id="billing_comuna_msg"></span></div>');
            jQuery('#billing_comuna').select2({ width: 'resolve', placeholder: 'Comuna' });
            jQuery('#billing_address_1_field').append('<div id="billing_sucursal_container" style="display:none;" class="form-row form-row-wide"><select style="width: 100%" id="billing_sucursal" name="billing_sucursal"></select><span style="color:red;" id="billing_sucursal_sucursal_msg"></span></div>');
            jQuery('#billing_sucursal').select2({ width: 'resolve', placeholder: 'Sucursal' });
            _ths.establecerComportamientoRadios('billing');
            _ths.establecerComunasAlCambiarPais('billing');
            _ths.establecerComunasAlCambiarRegiones('billing');
            _ths.establecerSucursalesAlCambiarComunas('billing');
            _ths.establecerDireccionAlCambiarSucursal('billing');
        }
        if(jQuery('.shipping_address').length > 0){
            if(jQuery('#shipping_tipoDespacho_field').length === 0){
                jQuery('#shipping_country_field').after('<p id="shipping_tipoDespacho_field" class="form-row form-row-wide" style="display:none;"></p>');
                jQuery('#shipping_tipoDespacho_field').append('<ul style="list-style: none; margin:0;"><li><input type="radio" name="shipping_tipoDespacho" id="shipping_ped" value="24"><label style="display:inline;" for="shipping_ped">Despacho a Domicilio</label></li><li><input type="radio" name="shipping_tipoDespacho" id="shipping_pes" value="07"><label style="display:inline;" for="shipping_pes">Despacho a Sucursal</label></li></ul>');
                jQuery('#shipping_city_field').append('<div id="shipping_comuna_container" style="display:none;"><select id="shipping_comuna" name="shipping_comuna" style="width: 100%"></select><span style="color:red;" id="shipping_comuna_msg"></span></div>');
                jQuery('#shipping_comuna').select2({ width: 'resolve', placeholder: 'Comuna' });
                jQuery('#shipping_address_1_field').append('<div id="shipping_sucursal_container" style="display:none;" class="form-row form-row-wide"><select style="width: 100%" id="shipping_sucursal" name="shipping_sucursal"></select><span style="color:red;" id="shipping_sucursal_msg"></span></div>');
                jQuery('#shipping_sucursal').select2({ width: 'resolve', placeholder: 'Sucursal' });
                _ths.establecerComportamientoRadios('shipping');
                _ths.establecerComunasAlCambiarPais('shipping');
                _ths.establecerComunasAlCambiarRegiones('shipping');
                _ths.establecerSucursalesAlCambiarComunas('shipping');
                _ths.establecerSucursalesAlCambiarComunas('shipping');
                _ths.establecerDireccionAlCambiarSucursal('shipping');
            }
            _ths.establecerComportamientoRadios('shipping');
        }
    };
    this.establecerComportamientoRadios = function(prefijo) {
        jQuery('#' + prefijo + '_ped').on('click', function() { 
            _ths.establecerVisualizacionDeControles(prefijo, true);
            jQuery('#ultimo_cambio').val(prefijo + '_tipoDespacho');
            if(prefijo === 'billing') {
                jQuery('#billing_address_1').val(_ths.billing_address_1);
                jQuery('#billing_address_2').val(_ths.billing_address_2);
            }
            if(prefijo === 'shipping'){
                jQuery('#shipping_address_1').val(_ths.shipping_address_1);
                jQuery('#shipping_address_2').val(_ths.shipping_address_2);
            }
            jQuery('body').trigger('update_checkout');
        });
        jQuery('#' + prefijo + '_pes').on('click', function() { 
            _ths.establecerVisualizacionDeControles(prefijo, true);
            jQuery('#ultimo_cambio').val(prefijo + '_tipoDespacho');
            if(prefijo === 'billing') {
                _ths.billing_address_1 = jQuery('#billing_address_1').val();
                _ths.billing_address_2 = jQuery('#billing_address_2').val();
                let sucursal = jQuery('#billing_sucursal option:selected').text();
                jQuery('#billing_address_1').val(sucursal);
                jQuery('#billing_address_2').val('');
            }
            if(prefijo === 'shipping') {
                _ths.shipping_address_1 = jQuery('#shipping_address_1').val();
                _ths.shipping_address_2 = jQuery('#shipping_address_2').val();
                let sucursal = jQuery('#shipping_sucursal option:selected').text();
                jQuery('#shipping_address_1').val(sucursal);
                jQuery('#shipping_address_2').val('');            
            }
            jQuery('body').trigger('update_checkout');
        });
    };    
    this.establecerComunasAlCambiarPais = function(prefijo) {
        jQuery('#' + prefijo + '_country').on('select2:selecting', function(){
            jQuery('#ultimo_cambio').val(prefijo + '_country');
            _ths.establecerVisualizacionDeControles(prefijo, true);
        });
    };    
    this.establecerComunasAlCambiarRegiones = function(prefijo) {
        jQuery('#' + prefijo + '_state').on('select2:selecting', function(e){
            jQuery('#ultimo_cambio').val(prefijo + '_state');
            jQuery('#' + prefijo + '_comuna').attr('disabled','disabled');
            jQuery('#' + prefijo + '_sucursal').attr('disabled','disabled');
        }).change(function(){
            jQuery('body').trigger('update_checkout');
        });
    };
    this.establecerSucursalesAlCambiarComunas = function(prefijo){
        jQuery('#' + prefijo + '_comuna').on('select2:selecting', function() {
            jQuery('#ultimo_cambio').val(prefijo + '_comuna');
            jQuery('#' + prefijo + '_sucursal').attr('disabled','disabled');
        }).change(function(){
            jQuery('body').trigger('update_checkout');
        });
    };
    this.establecerDireccionAlCambiarSucursal = function(prefijo){
        jQuery('#' + prefijo + '_sucursal').change(function() {
            let sucursal = jQuery('#' + prefijo + '_sucursal option:selected').text();
            jQuery('#' + prefijo + '_address_1').val(sucursal);
            jQuery('#' + prefijo + '_address_2').val('');
            jQuery('body').trigger('update_checkout');
        });
    };
    this.restablecerValores = function(){
        if(_ths.prms && _ths.prms.billing_tipoDespacho && _ths.prms.billing_tipoDespacho === '07')
            jQuery('#billing_pes').attr('checked','checked');
        else 
            jQuery('#billing_ped').attr('checked','checked');
        jQuery('#billing_comuna').attr('disabled','disabled');
        jQuery('#billing_sucursal').attr('disabled','disabled');
        let billing_region = jQuery('#billing_state').val();
        let billing_comuna = jQuery('#billing_city').val();
        let billing_direccion = jQuery('#billing_address_1').val();
        if(billing_region !== ''){
            _ths.cargarComunas('billing', billing_region, function() {
                if(billing_comuna !== '') {
                    jQuery('#billing_comuna option').each(function(i, opt){
                        if(jQuery(opt).text() === billing_comuna){
                            jQuery('#billing_comuna').val(jQuery(opt).val());
                            return false;
                        }
                    });
                    _ths.cargarSucursales('billing', jQuery('#billing_comuna').val(), function() {
                        if(jQuery('#billing_pes').is(':checked') && billing_direccion !== ''){
                            jQuery('#billing_sucursal option').each(function(i, opt){
                                if(jQuery(opt).text() === billing_direccion) {
                                    jQuery('#billing_sucursal').val(jQuery(opt).val());
                                    return false;
                                }
                            });
                            _ths.establecerVisualizacionDeControles('billing', true);
                        } else {
                            _ths.establecerVisualizacionDeControles('billing', true);   
                        }
                    });
                } else {
                    _ths.establecerVisualizacionDeControles('billing', true);   
                }
            });
        } else {
            _ths.establecerVisualizacionDeControles('billing', true);
        }

        if(jQuery('.shipping_address').length > 0) {
            if(_ths.prms && _ths.prms.shipping_tipoDespacho && _ths.prms.shipping_tipoDespacho === '07')
                jQuery('#shipping_pes').attr('checked','checked');
            else 
                jQuery('#shipping_ped').attr('checked','checked');
            jQuery('#shipping_comuna').attr('disabled','disabled');
            jQuery('#shipping_sucursal').attr('disabled','disabled');
            let shipping_region = jQuery('#shipping_state').val();
            let shipping_comuna = jQuery('#shipping_city').val();
            let shipping_direccion = jQuery('#shipping_address_1').val();
            if(shipping_region !== ''){
                _ths.cargarComunas('shipping', shipping_region, function() {
                    if(shipping_comuna !== '') {
                        jQuery('#shipping_comuna option').each(function(i, opt){
                            if(jQuery(opt).text() === shipping_comuna){
                                jQuery('#shipping_comuna').val(jQuery(opt).val());
                                return false;
                            }
                        });
                        _ths.cargarSucursales('shipping', jQuery('#shipping_comuna').val(), function() {
                            if(jQuery('#shipping_pes').is(':checked') && shipping_direccion !== ''){
                                jQuery('#shipping_sucursal option').each(function(i, opt){
                                    if(jQuery(opt).text() === shipping_direccion) {
                                        jQuery('#shipping_sucursal').val(jQuery(opt).val());
                                        return false;
                                    }
                                });
                                _ths.establecerVisualizacionDeControles('shipping', true);   
                            }else {
                                _ths.establecerVisualizacionDeControles('shipping', true);   
                            }
                        });
                    } else {
                        _ths.establecerVisualizacionDeControles('shipping', true);   
                    }
                });
            } else {
                _ths.establecerVisualizacionDeControles('shipping', true);   
            }
        }
    };        
    this.establecerValoresPorDefecto = function(){
        if(!jQuery('#billing_ped').is(':checked') && !jQuery('#billing_pes').is(':checked')) jQuery('#billing_ped').attr('checked','checked');
        if(!jQuery('#shipping_ped').is(':checked') && !jQuery('#shipping_pes').is(':checked')) jQuery('#shipping_ped').attr('checked','checked');
    };
    this.cargarComunas = function(prefijo, region, fx){
        if(!region || region === '')
            return;
        jQuery('#' + prefijo + '_sucursal').attr('disabled', 'disabled');
        jQuery('#' + prefijo + '_sucursal').empty();
        jQuery('#' + prefijo + '_comuna').empty();
        jQuery('#' + prefijo + '_comuna').append('<option value=""></option>');
        jQuery('#customer_details').block({ message: null, overlayCSS: { backgroundColor: '#fff', opacity: 0.6, cursor: 'wait' } });
        jQuery.ajax({
            url: correoschile_var.url,
            dataType: 'json',
            type: 'post',
            data: { 'action': 'correoschile_comunas', 'nonce' : correoschile_var.nonce_comunas, 'region': region },
            success: function(comunas) {
                jQuery('#' + prefijo + '_comuna_msg').text('');
                jQuery(comunas).each(function(i, c) {
                    jQuery('#' + prefijo + '_comuna').append('<option value=' + String(c.Iata).trim() + '>' + String(c.NombreComuna).trim() + '</option>');
                });
                jQuery('#customer_details').unblock();
                jQuery('#' + prefijo + '_comuna').removeAttr('disabled');
                if(_ths.isFunction(fx))
                    fx();
            },
            error: function(xhr) {
                if (xhr && xhr.responseJSON && xhr.responseJSON.message)
                    console.log(xhr.responseJSON.message);
                jQuery('#' + prefijo + '_comuna_msg').text('Ocurrio un error intentando cargar las comunas.');
                jQuery('#customer_details').unblock();
                if(_ths.isFunction(fx))
                    fx();
            }
        });
    };
    this.cargarSucursales = function(prefijo, codigoComuna, fx){
        if(!codigoComuna || codigoComuna === '')
            return;
        jQuery('#' + prefijo + '_sucursal').empty();
        jQuery('#' + prefijo + '_sucursal').append('<option value=""></option>');
        jQuery('#customer_details').block({ message: null, overlayCSS: { backgroundColor: '#fff', opacity: 0.6, cursor: 'wait' } });
        jQuery.ajax({
            url: correoschile_var.url,
            dataType:'json',
            type:'post',
            data:{ 'action': 'correoschile_sucursales', 'nonce' : correoschile_var.nonce_sucursales, 'codigoComuna': codigoComuna },
            success:function(sucursales) {
                jQuery('#' + prefijo + '_sucursal_msg').text('');
                jQuery(sucursales).each(function(i, s) {
                    if(s.IataOficina)
                        jQuery('#' + prefijo + '_sucursal').append('<option value=' + String(s.IataOficina).trim() + '>' + String(s.DescripcionOficina).trim() + '</option>');
                });
                jQuery('#customer_details').unblock();
                jQuery('#' + prefijo + '_sucursal').removeAttr('disabled');
                if(_ths.isFunction(fx))
                    fx();
            },
            error: function(xhr) {
                if (xhr && xhr.responseJSON && xhr.responseJSON.message)
                    console.log(xhr.responseJSON.message);
                jQuery('#' + prefijo + '_sucursal_msg').text('Ocurrio un error intentando cargar las sucursales.');
                jQuery('#customer_details').unblock();
                if(_ths.isFunction(fx))
                    fx();
            }
        });
    };
    this.isFunction = function (n) {
        var t = typeof n;
        return t === "function" ? !0 : !1;
    };
    this.establecerVisualizacionDeControles = function(prefijo, ok){
        if (!prefijo || prefijo === '')
            return;
        if(jQuery('#' + prefijo + '_country').val() === 'CL' && ok) {
            jQuery('#' + prefijo + '_tipoDespacho_field').show();
            jQuery('#' + prefijo + '_city').hide();
            jQuery('#' + prefijo + '_comuna_container').show();
            jQuery('#' + prefijo + '_sucursal_container').hide();
            jQuery('#' + prefijo + '_address_1').hide();
            jQuery('#' + prefijo + '_address_2_field').hide();
            var tipoEnvio = jQuery('input:radio[name=' + prefijo + '_tipoDespacho]:checked').val();
            if(tipoEnvio) {
                if(tipoEnvio === '24'){ jQuery('#' + prefijo + '_address_1').show(); jQuery('#' + prefijo + '_address_2_field').show(); }
                if(tipoEnvio === '07'){ jQuery('#' + prefijo + '_sucursal_container').show(); }
            }
            //jQuery('#' + prefijo + '_postcode_field').hide();       
        } else {
            jQuery('#' + prefijo + '_tipoDespacho_field').hide();
            jQuery('#' + prefijo + '_comuna_container').hide();
            jQuery('#' + prefijo + '_city').show();
            jQuery('#' + prefijo + '_comuna_container').hide();
            jQuery('#' + prefijo + '_sucursal_container').hide();
            //jQuery('#' + prefijo + '_postcode_field').show();
        }
    }
    _ths.iniciar();
};


